# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class SecuritySubscriptionRequest(object):

    """Implementation of the 'SecuritySubscriptionRequest' model.

    Request for a subscription.

    Attributes:
        account_name (str): The name of a billing account.
        sku_number (str): The Stock Keeping Unit (SKU). Valid skuNumbers for
            SIM-Secure for IoT are:SIMSec-IoT-Lt”. (Lifetime) Once a license
            is assigned to a SIM, the SIM-Secure feature is enabled for the
            life of the SIM.“TS-BUNDLE-KTO-SIMSEC-MRC”. (Bundle) The
            SIM-Secure Flex license can be assigned to or removed from a SIM
            at any time. This SKU is bundled with other ThingSpace
            Services.*“SIMSec-IoT”. (Flex) The SIM-Secure Flex license can be
            assigned to or removed from a SIM at any time. This SKU is
            purchased a la carte.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "sku_number": 'skuNumber'
    }

    _optionals = [
        'account_name',
        'sku_number',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 sku_number=APIHelper.SKIP):
        """Constructor for the SecuritySubscriptionRequest class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if sku_number is not APIHelper.SKIP:
            self.sku_number = sku_number 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        sku_number = dictionary.get("skuNumber") if dictionary.get("skuNumber") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   sku_number)
