# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.security_subscription import SecuritySubscription


class SecuritySubscriptionResult(object):

    """Implementation of the 'SecuritySubscriptionResult' model.

    Response for a subscription request.

    Attributes:
        account_name (str): The name of a billing account.
        subscription_list (List[SecuritySubscription]): The list of SKU
            numbers and counts for each license type specified in the
            request.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "subscription_list": 'subscriptionList'
    }

    _optionals = [
        'account_name',
        'subscription_list',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 subscription_list=APIHelper.SKIP):
        """Constructor for the SecuritySubscriptionResult class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if subscription_list is not APIHelper.SKIP:
            self.subscription_list = subscription_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        subscription_list = None
        if dictionary.get('subscriptionList') is not None:
            subscription_list = [SecuritySubscription.from_dictionary(x) for x in dictionary.get('subscriptionList')]
        else:
            subscription_list = APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   subscription_list)
