# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.gio_request_response import GIORequestResponse
from verizon.models.status_response import StatusResponse
from verizon.exceptions.gio_rest_error_response_exception import GIORestErrorResponseException


class DeviceActionsController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(DeviceActionsController, self).__init__(config)

    def retrieve_the_global_device_list(self,
                                        body):
        """Does a POST request to /m2m/v2/devices/actions/list.

        Allows the profile to fetch the complete device list. This works with
        Verizon US and Global profiles.

        Args:
            body (GetDeviceListWithProfilesRequest): Device Profile Query

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                ID

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v2/devices/actions/list')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(GIORequestResponse.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Error response', GIORestErrorResponseException)
        ).execute()

    def retrieve_device_provisioning_history(self,
                                             body):
        """Does a POST request to /m2m/v2/devices/history/actions/list.

        Retreive the provisioning history of a specific device or devices.

        Args:
            body (ProvhistoryRequest): Device Provisioning History

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                ID

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v2/devices/history/actions/list')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(GIORequestResponse.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Error response', GIORestErrorResponseException)
        ).execute()

    def get_asynchronous_request_status(self,
                                        account_name,
                                        request_id):
        """Does a GET request to /m2m/v2/accounts/{accountName}/requests/{requestID}/status.

        Get the status of an asynchronous request made with the Device
        Actions.

        Args:
            account_name (str): TODO: type description here.
            request_id (str): TODO: type description here.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                ID

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v2/accounts/{accountName}/requests/{requestID}/status')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('accountName')
                            .value(account_name)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('requestID')
                            .value(request_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(StatusResponse.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Error response', GIORestErrorResponseException)
        ).execute()
