# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.location import Location
from verizon.models.synchronous_location_request_result import SynchronousLocationRequestResult
from verizon.models.transaction_id import TransactionID
from verizon.models.asynchronous_location_request_result import AsynchronousLocationRequestResult
from verizon.models.location_report import LocationReport
from verizon.models.location_report_status import LocationReportStatus
from verizon.exceptions.device_location_result_exception import DeviceLocationResultException


class DevicesLocationsController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(DevicesLocationsController, self).__init__(config)

    def list_devices_locations_synchronous(self,
                                           body):
        """Does a POST request to /locations.

        This locations endpoint retrieves the locations for a list of
        devices.

        Args:
            body (LocationRequest): Request to obtain location of devices.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. List of
                JSON objects, each containing the position data or an error
                for a device in the request.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/locations')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(Location.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Unexpected error.', DeviceLocationResultException)
        ).execute()

    def list_devices_locations_asynchronous(self,
                                            body):
        """Does a POST request to /devicelocations.

        Requests the current or cached location of up to 10,000 IoT or
        consumer devices (phones, tablets. etc.). This request returns a
        synchronous transaction ID, and the location information for each
        device is returned asynchronously as a DeviceLocation callback
        message.

        Args:
            body (LocationRequest): An asynchronous request to obtain
                locations of devices.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                accepted; location report in progress

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/devicelocations')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('*/*'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(SynchronousLocationRequestResult.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Unexpected error.', DeviceLocationResultException)
        ).execute()

    def cancel_device_location_request(self,
                                       account_name,
                                       txid):
        """Does a DELETE request to /devicelocations/{txid}.

        Cancel a queued or unfinished device location request.

        Args:
            account_name (str): Account identifier in "##########-#####".
            txid (str): Transaction ID of the request to cancel, from the
                synchronous response to the original request.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                canceled.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/devicelocations/{txid}')
            .http_method(HttpMethodEnum.DELETE)
            .query_param(Parameter()
                         .key('accountName')
                         .value(account_name))
            .template_param(Parameter()
                            .key('txid')
                            .value(txid)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TransactionID.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Unexpected error.', DeviceLocationResultException)
        ).execute()

    def create_location_report(self,
                               body):
        """Does a POST request to /locationreports.

        Request an asynchronous device location report.

        Args:
            body (LocationRequest): Request for device location report.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                accepted; location report in progress.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/locationreports')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('*/*'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(AsynchronousLocationRequestResult.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Unexpected error.', DeviceLocationResultException)
        ).execute()

    def retrieve_location_report(self,
                                 account,
                                 txid,
                                 startindex):
        """Does a GET request to /locationreports/{account}/report/{txid}/index/{startindex}.

        Download a completed asynchronous device location report.

        Args:
            account (str): Account identifier in "##########-#####".
            txid (str): Transaction ID from POST /locationreports response.
            startindex (int): Zero-based number of the first record to
                return.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Location
                information for up to 1,000 devices.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/locationreports/{account}/report/{txid}/index/{startindex}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('txid')
                            .value(txid)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('startindex')
                            .value(startindex)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(LocationReport.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Unexpected error.', DeviceLocationResultException)
        ).execute()

    def get_location_report_status(self,
                                   account,
                                   txid):
        """Does a GET request to /locationreports/{account}/report/{txid}/status.

        Returns the current status of a requested device location report.

        Args:
            account (str): Account identifier in "##########-#####".
            txid (str): Transaction ID of the report.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Location
                report status.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/locationreports/{account}/report/{txid}/status')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('txid')
                            .value(txid)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(LocationReportStatus.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Unexpected error.', DeviceLocationResultException)
        ).execute()

    def cancel_queued_location_report_generation(self,
                                                 account,
                                                 txid):
        """Does a DELETE request to /locationreports/{account}/report/{txid}.

        Cancel a queued device location report.

        Args:
            account (str): Account identifier in "##########-#####".
            txid (str): Transaction ID of the report to cancel.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Report
                generation cancelled.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/locationreports/{account}/report/{txid}')
            .http_method(HttpMethodEnum.DELETE)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('txid')
                            .value(txid)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TransactionID.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Unexpected error.', DeviceLocationResultException)
        ).execute()
