# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.device_diagnostics_callback import DeviceDiagnosticsCallback
from verizon.exceptions.device_diagnostics_result_exception import DeviceDiagnosticsResultException


class DiagnosticsCallbacksController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(DiagnosticsCallbacksController, self).__init__(config)

    def get_diagnostics_subscription_callback_info(self,
                                                   account_name):
        """Does a GET request to /callbacks.

        This endpoint allows user to get the registered callback information
        of an existing diagnostics subscription.

        Args:
            account_name (str): Account identifier.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Returns
                callback registration.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_DIAGNOSTICS)
            .path('/callbacks')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('accountName')
                         .value(account_name))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(DeviceDiagnosticsCallback.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', DeviceDiagnosticsResultException)
        ).execute()

    def register_diagnostics_callback_url(self,
                                          body):
        """Does a POST request to /callbacks.

        This endpoint allows user update the callback HTTPS address of an
        existing diagnostics subscription.

        Args:
            body (CallbackRegistrationRequest): Callback URL registration
                request.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Returns
                callback registration.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_DIAGNOSTICS)
            .path('/callbacks')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('*/*'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(DeviceDiagnosticsCallback.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', DeviceDiagnosticsResultException)
        ).execute()

    def unregister_diagnostics_callback(self,
                                        account_name,
                                        service_name):
        """Does a DELETE request to /callbacks.

        This endpoint allows user to delete a registered callback URL and
        credential.

        Args:
            account_name (str): Account identifier.
            service_name (str): Service name for callback notification.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Device
                diagnostics callback registration.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_DIAGNOSTICS)
            .path('/callbacks')
            .http_method(HttpMethodEnum.DELETE)
            .query_param(Parameter()
                         .key('accountName')
                         .value(account_name))
            .query_param(Parameter()
                         .key('serviceName')
                         .value(service_name))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(DeviceDiagnosticsCallback.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', DeviceDiagnosticsResultException)
        ).execute()
