# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.fota_v3_callback_summary import FotaV3CallbackSummary
from verizon.models.fota_v3_callback_registration_result import FotaV3CallbackRegistrationResult
from verizon.models.fota_v3_success_result import FotaV3SuccessResult
from verizon.exceptions.fota_v3_result_exception import FotaV3ResultException


class SoftwareManagementCallbacksV3Controller(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(SoftwareManagementCallbacksV3Controller, self).__init__(config)

    def list_registered_callbacks(self,
                                  acc):
        """Does a GET request to /callbacks/{acc}.

        This endpoint allows user to get the registered callback information.

        Args:
            acc (str): Account identifier.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Return
                callback registration.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/callbacks/{acc}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FotaV3CallbackSummary.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()

    def update_callback(self,
                        acc,
                        body):
        """Does a PUT request to /callbacks/{acc}.

        This endpoint allows the user to update the HTTPS callback address.

        Args:
            acc (str): Account identifier.
            body (FotaV3CallbackRegistrationRequest): Callback URL
                registration.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Return
                callback registration.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/callbacks/{acc}')
            .http_method(HttpMethodEnum.PUT)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FotaV3CallbackRegistrationResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()

    def register_callback(self,
                          acc,
                          body):
        """Does a POST request to /callbacks/{acc}.

        This endpoint allows the user to create the HTTPS callback address.

        Args:
            acc (str): Account identifier.
            body (FotaV3CallbackRegistrationRequest): Callback URL
                registration.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Return
                callback registration.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/callbacks/{acc}')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FotaV3CallbackRegistrationResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()

    def deregister_callback(self,
                            acc):
        """Does a DELETE request to /callbacks/{acc}.

        This endpoint allows user to delete a previously registered callback
        URL.

        Args:
            acc (str): Account identifier.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Delete
                request result.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/callbacks/{acc}')
            .http_method(HttpMethodEnum.DELETE)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FotaV3SuccessResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()
