# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class AggregateUsageItem(object):

    """Implementation of the 'AggregateUsageItem' model.

    Contains usage information per device.

    Attributes:
        imei (str): International Mobile Equipment Identifier. This is the ID
            of the device reporting usage.
        number_of_sessions (int): Number of sessions established by the device
            reporting usage.
        bytes_transferred (int): The amount of data transferred by the device
            reporting usage, measured in Bytes.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "imei": 'imei',
        "number_of_sessions": 'numberOfSessions',
        "bytes_transferred": 'bytesTransferred'
    }

    _optionals = [
        'imei',
        'number_of_sessions',
        'bytes_transferred',
    ]

    def __init__(self,
                 imei=APIHelper.SKIP,
                 number_of_sessions=APIHelper.SKIP,
                 bytes_transferred=APIHelper.SKIP):
        """Constructor for the AggregateUsageItem class"""

        # Initialize members of the class
        if imei is not APIHelper.SKIP:
            self.imei = imei 
        if number_of_sessions is not APIHelper.SKIP:
            self.number_of_sessions = number_of_sessions 
        if bytes_transferred is not APIHelper.SKIP:
            self.bytes_transferred = bytes_transferred 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        imei = dictionary.get("imei") if dictionary.get("imei") else APIHelper.SKIP
        number_of_sessions = dictionary.get("numberOfSessions") if dictionary.get("numberOfSessions") else APIHelper.SKIP
        bytes_transferred = dictionary.get("bytesTransferred") if dictionary.get("bytesTransferred") else APIHelper.SKIP
        # Return an object of this model
        return cls(imei,
                   number_of_sessions,
                   bytes_transferred)
