# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class ConnectivityManagementCallback(object):

    """Implementation of the 'ConnectivityManagementCallback' model.

    Includes callback listeners that were registered through the Connectivity
    Management API.

    Attributes:
        account_name (str): The name of the billing account for which callback
            messages will be sent.
        password (str): The password defined when a URL was registered for the
            callback service, or an empty string if no password was defined.
        service_name (str): The name of the callback service, which identifies
            the type and format of messages that will be sent to the
            registered URL.
        url (str): The address of the callback listening service where the
            ThingSpace Platform will send callback messages for the service
            type.
        username (str): The username defined when a URL was registered for the
            callback service, or an empty string if no username was defined.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "password": 'password',
        "service_name": 'serviceName',
        "url": 'url',
        "username": 'username'
    }

    _optionals = [
        'account_name',
        'password',
        'service_name',
        'url',
        'username',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 password=APIHelper.SKIP,
                 service_name=APIHelper.SKIP,
                 url=APIHelper.SKIP,
                 username=APIHelper.SKIP):
        """Constructor for the ConnectivityManagementCallback class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if password is not APIHelper.SKIP:
            self.password = password 
        if service_name is not APIHelper.SKIP:
            self.service_name = service_name 
        if url is not APIHelper.SKIP:
            self.url = url 
        if username is not APIHelper.SKIP:
            self.username = username 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        password = dictionary.get("password") if dictionary.get("password") else APIHelper.SKIP
        service_name = dictionary.get("serviceName") if dictionary.get("serviceName") else APIHelper.SKIP
        url = dictionary.get("url") if dictionary.get("url") else APIHelper.SKIP
        username = dictionary.get("username") if dictionary.get("username") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   password,
                   service_name,
                   url,
                   username)
