# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from verizon.api_helper import APIHelper


class DeviceFirmwareUpgrade(object):

    """Implementation of the 'DeviceFirmwareUpgrade' model.

    Firmware upgrades information.

    Attributes:
        device_id (str): Device identifier.
        campaign_id (str): Campaign identifier.
        account_name (str): Account identifier.
        firmware_name (str): Firmware name.
        firmware_from (str): Old firmware version.
        firmware_to (str): New firmware version.
        start_date (date): Firmware upgrade start date.
        status (str): Firmware upgrade status.
        reason (str): Software upgrade result reason.
        report_updated_time (str): Report updated time.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "campaign_id": 'campaignId',
        "account_name": 'accountName',
        "start_date": 'startDate',
        "status": 'status',
        "reason": 'reason',
        "firmware_name": 'firmwareName',
        "firmware_from": 'firmwareFrom',
        "firmware_to": 'firmwareTo',
        "report_updated_time": 'reportUpdatedTime'
    }

    _optionals = [
        'firmware_name',
        'firmware_from',
        'firmware_to',
        'report_updated_time',
    ]

    def __init__(self,
                 device_id=None,
                 campaign_id=None,
                 account_name=None,
                 start_date=None,
                 status=None,
                 reason=None,
                 firmware_name=APIHelper.SKIP,
                 firmware_from=APIHelper.SKIP,
                 firmware_to=APIHelper.SKIP,
                 report_updated_time=APIHelper.SKIP):
        """Constructor for the DeviceFirmwareUpgrade class"""

        # Initialize members of the class
        self.device_id = device_id 
        self.campaign_id = campaign_id 
        self.account_name = account_name 
        if firmware_name is not APIHelper.SKIP:
            self.firmware_name = firmware_name 
        if firmware_from is not APIHelper.SKIP:
            self.firmware_from = firmware_from 
        if firmware_to is not APIHelper.SKIP:
            self.firmware_to = firmware_to 
        self.start_date = start_date 
        self.status = status 
        self.reason = reason 
        if report_updated_time is not APIHelper.SKIP:
            self.report_updated_time = report_updated_time 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = dictionary.get("deviceId") if dictionary.get("deviceId") else None
        campaign_id = dictionary.get("campaignId") if dictionary.get("campaignId") else None
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        start_date = dateutil.parser.parse(dictionary.get('startDate')).date() if dictionary.get('startDate') else None
        status = dictionary.get("status") if dictionary.get("status") else None
        reason = dictionary.get("reason") if dictionary.get("reason") else None
        firmware_name = dictionary.get("firmwareName") if dictionary.get("firmwareName") else APIHelper.SKIP
        firmware_from = dictionary.get("firmwareFrom") if dictionary.get("firmwareFrom") else APIHelper.SKIP
        firmware_to = dictionary.get("firmwareTo") if dictionary.get("firmwareTo") else APIHelper.SKIP
        report_updated_time = dictionary.get("reportUpdatedTime") if dictionary.get("reportUpdatedTime") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_id,
                   campaign_id,
                   account_name,
                   start_date,
                   status,
                   reason,
                   firmware_name,
                   firmware_from,
                   firmware_to,
                   report_updated_time)
