# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class FirmwareUpgradeDeviceListItem(object):

    """Implementation of the 'FirmwareUpgradeDeviceListItem' model.

    A JSON object for each device that was included in the upgrade, showing
    the device IMEI, the status of the upgrade, and additional information
    about the status.

    Attributes:
        device_id (str): Device IMEI.
        status (str): The status of the upgrade for this device.
        result_reason (str): Additional details about the status. Not included
            when status='Request Pending.'

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "status": 'status',
        "result_reason": 'resultReason'
    }

    _optionals = [
        'device_id',
        'status',
        'result_reason',
    ]

    def __init__(self,
                 device_id=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 result_reason=APIHelper.SKIP):
        """Constructor for the FirmwareUpgradeDeviceListItem class"""

        # Initialize members of the class
        if device_id is not APIHelper.SKIP:
            self.device_id = device_id 
        if status is not APIHelper.SKIP:
            self.status = status 
        if result_reason is not APIHelper.SKIP:
            self.result_reason = result_reason 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = dictionary.get("deviceId") if dictionary.get("deviceId") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        result_reason = dictionary.get("resultReason") if dictionary.get("resultReason") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_id,
                   status,
                   result_reason)
