# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class FotaV1CallbackRegistrationResult(object):

    """Implementation of the 'FotaV1CallbackRegistrationResult' model.

    Registered callback account name and service name.

    Attributes:
        account_name (str): The name of the billing account for which callback
            messages will be sent.
        service_name (str): The name of the callback service, which identifies
            the type and format of messages that will be sent to the
            registered URL. This will be 'Fota' for the Software Management
            Services callback.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "service_name": 'serviceName'
    }

    _optionals = [
        'account_name',
        'service_name',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 service_name=APIHelper.SKIP):
        """Constructor for the FotaV1CallbackRegistrationResult class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if service_name is not APIHelper.SKIP:
            self.service_name = service_name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        service_name = dictionary.get("serviceName") if dictionary.get("serviceName") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   service_name)
