# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.region import Region


class ListRegionsResult(object):

    """Implementation of the 'ListRegionsResult' model.

    Response to return an array of all regions in the Verizon 5G Edge service.
    You can use the region IDs from the response to find optimal Edge
    platforms or service endpoints.

    Attributes:
        regions (List[Region]): An array of all regions in the Verizon 5G Edge
            service.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "regions": 'regions'
    }

    _optionals = [
        'regions',
    ]

    def __init__(self,
                 regions=APIHelper.SKIP):
        """Constructor for the ListRegionsResult class"""

        # Initialize members of the class
        if regions is not APIHelper.SKIP:
            self.regions = regions 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        regions = None
        if dictionary.get('regions') is not None:
            regions = [Region.from_dictionary(x) for x in dictionary.get('regions')]
        else:
            regions = APIHelper.SKIP
        # Return an object of this model
        return cls(regions)
