# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.fields_2 import Fields2


class SearchDeviceResponse(object):

    """Implementation of the 'SearchDeviceResponse' model.

    A success response includes an array of all matching events. Each event
    includes the full event resource definition.

    Attributes:
        action (str): The action requested in this event; “change” for device
            configuration changes.
        createdon (str): The date and time of the change request.
        deviceid (str): The device’s ThingSpace UUID.
        fields (Fields2): List of fields affected by the event.
        id (str): The unique ID of this ts.event.configuration event.
        kind (str): The kind of the ThingSpace resource that is being
            reported; “ts.event.configuration” for device configuration
            changes.
        lastupdated (str): The date and time that the event was last updated.
        name (str): The name of the event
        state (str): The current status of the request.
        tagids (List[str]): UUIDs of tag resources that are applied to this
            device.
        transactionid (str): transaction id
        version (str): The version of the resource.
        versionid (str): The version of the resource.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "action": 'action',
        "createdon": 'createdon',
        "deviceid": 'deviceid',
        "fields": 'fields',
        "id": 'id',
        "kind": 'kind',
        "lastupdated": 'lastupdated',
        "name": 'name',
        "state": 'state',
        "tagids": 'tagids',
        "transactionid": 'transactionid',
        "version": 'version',
        "versionid": 'versionid'
    }

    _optionals = [
        'action',
        'createdon',
        'deviceid',
        'fields',
        'id',
        'kind',
        'lastupdated',
        'name',
        'state',
        'tagids',
        'transactionid',
        'version',
        'versionid',
    ]

    def __init__(self,
                 action=APIHelper.SKIP,
                 createdon=APIHelper.SKIP,
                 deviceid=APIHelper.SKIP,
                 fields=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 kind=APIHelper.SKIP,
                 lastupdated=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 state=APIHelper.SKIP,
                 tagids=APIHelper.SKIP,
                 transactionid=APIHelper.SKIP,
                 version=APIHelper.SKIP,
                 versionid=APIHelper.SKIP):
        """Constructor for the SearchDeviceResponse class"""

        # Initialize members of the class
        if action is not APIHelper.SKIP:
            self.action = action 
        if createdon is not APIHelper.SKIP:
            self.createdon = createdon 
        if deviceid is not APIHelper.SKIP:
            self.deviceid = deviceid 
        if fields is not APIHelper.SKIP:
            self.fields = fields 
        if id is not APIHelper.SKIP:
            self.id = id 
        if kind is not APIHelper.SKIP:
            self.kind = kind 
        if lastupdated is not APIHelper.SKIP:
            self.lastupdated = lastupdated 
        if name is not APIHelper.SKIP:
            self.name = name 
        if state is not APIHelper.SKIP:
            self.state = state 
        if tagids is not APIHelper.SKIP:
            self.tagids = tagids 
        if transactionid is not APIHelper.SKIP:
            self.transactionid = transactionid 
        if version is not APIHelper.SKIP:
            self.version = version 
        if versionid is not APIHelper.SKIP:
            self.versionid = versionid 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        action = dictionary.get("action") if dictionary.get("action") else APIHelper.SKIP
        createdon = dictionary.get("createdon") if dictionary.get("createdon") else APIHelper.SKIP
        deviceid = dictionary.get("deviceid") if dictionary.get("deviceid") else APIHelper.SKIP
        fields = Fields2.from_dictionary(dictionary.get('fields')) if 'fields' in dictionary.keys() else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        kind = dictionary.get("kind") if dictionary.get("kind") else APIHelper.SKIP
        lastupdated = dictionary.get("lastupdated") if dictionary.get("lastupdated") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        state = dictionary.get("state") if dictionary.get("state") else APIHelper.SKIP
        tagids = dictionary.get("tagids") if dictionary.get("tagids") else APIHelper.SKIP
        transactionid = dictionary.get("transactionid") if dictionary.get("transactionid") else APIHelper.SKIP
        version = dictionary.get("version") if dictionary.get("version") else APIHelper.SKIP
        versionid = dictionary.get("versionid") if dictionary.get("versionid") else APIHelper.SKIP
        # Return an object of this model
        return cls(action,
                   createdon,
                   deviceid,
                   fields,
                   id,
                   kind,
                   lastupdated,
                   name,
                   state,
                   tagids,
                   transactionid,
                   version,
                   versionid)
