# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.extended_attributes import ExtendedAttributes


class SecuritySubscription(object):

    """Implementation of the 'SecuritySubscription' model.

    Subscription of the device.

    Attributes:
        extended_attributes (List[ExtendedAttributes]): Attributes of the
            subscription.
        license_assigned (int): The total number of licenses for this license
            type that are assigned to device SIMs.
        license_available (int): The total number of licenses for this license
            type that are available to assign to device SIMs.
        license_purchased (int): The total number of licenses purchased for
            the license type.
        license_type (str): The license type associated with the skuNumber.
        sku_number (str): The skuNumber that identifies the license type.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "extended_attributes": 'extendedAttributes',
        "license_assigned": 'licenseAssigned',
        "license_available": 'licenseAvailable',
        "license_purchased": 'licensePurchased',
        "license_type": 'licenseType',
        "sku_number": 'skuNumber'
    }

    _optionals = [
        'extended_attributes',
        'license_assigned',
        'license_available',
        'license_purchased',
        'license_type',
        'sku_number',
    ]

    def __init__(self,
                 extended_attributes=APIHelper.SKIP,
                 license_assigned=APIHelper.SKIP,
                 license_available=APIHelper.SKIP,
                 license_purchased=APIHelper.SKIP,
                 license_type=APIHelper.SKIP,
                 sku_number=APIHelper.SKIP):
        """Constructor for the SecuritySubscription class"""

        # Initialize members of the class
        if extended_attributes is not APIHelper.SKIP:
            self.extended_attributes = extended_attributes 
        if license_assigned is not APIHelper.SKIP:
            self.license_assigned = license_assigned 
        if license_available is not APIHelper.SKIP:
            self.license_available = license_available 
        if license_purchased is not APIHelper.SKIP:
            self.license_purchased = license_purchased 
        if license_type is not APIHelper.SKIP:
            self.license_type = license_type 
        if sku_number is not APIHelper.SKIP:
            self.sku_number = sku_number 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        extended_attributes = None
        if dictionary.get('extendedAttributes') is not None:
            extended_attributes = [ExtendedAttributes.from_dictionary(x) for x in dictionary.get('extendedAttributes')]
        else:
            extended_attributes = APIHelper.SKIP
        license_assigned = dictionary.get("licenseAssigned") if dictionary.get("licenseAssigned") else APIHelper.SKIP
        license_available = dictionary.get("licenseAvailable") if dictionary.get("licenseAvailable") else APIHelper.SKIP
        license_purchased = dictionary.get("licensePurchased") if dictionary.get("licensePurchased") else APIHelper.SKIP
        license_type = dictionary.get("licenseType") if dictionary.get("licenseType") else APIHelper.SKIP
        sku_number = dictionary.get("skuNumber") if dictionary.get("skuNumber") else APIHelper.SKIP
        # Return an object of this model
        return cls(extended_attributes,
                   license_assigned,
                   license_available,
                   license_purchased,
                   license_type,
                   sku_number)
