# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class V2ListOfLicensesToRemoveRequest(object):

    """Implementation of the 'V2ListOfLicensesToRemoveRequest' model.

    License cancellation candidate devices.

    Attributes:
        mtype (str): List creation option.
        count (int): The number of devices.
        device_list (List[str]): Device IMEI list.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_list": 'deviceList',
        "mtype": 'type',
        "count": 'count'
    }

    _optionals = [
        'mtype',
        'count',
    ]

    def __init__(self,
                 device_list=None,
                 mtype=APIHelper.SKIP,
                 count=APIHelper.SKIP):
        """Constructor for the V2ListOfLicensesToRemoveRequest class"""

        # Initialize members of the class
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if count is not APIHelper.SKIP:
            self.count = count 
        self.device_list = device_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_list = dictionary.get("deviceList") if dictionary.get("deviceList") else None
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        count = dictionary.get("count") if dictionary.get("count") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_list,
                   mtype,
                   count)
