# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.and_auth_group import And
from verizon.models.firmware_campaign import FirmwareCampaign
from verizon.models.v3_add_or_remove_device_result import V3AddOrRemoveDeviceResult
from verizon.models.campaign import Campaign
from verizon.models.fota_v3_success_result import FotaV3SuccessResult
from verizon.exceptions.fota_v3_result_exception import FotaV3ResultException


class CampaignsV3Controller(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(CampaignsV3Controller, self).__init__(config)

    def schedule_campaign_firmware_upgrade(self,
                                           acc,
                                           body):
        """Does a POST request to /campaigns/firmware/{acc}.

        This endpoint allows a user to schedule a firmware upgrade for a list
        of devices.

        Args:
            acc (str): Account identifier.
            body (CampaignFirmwareUpgrade): Firmware upgrade information.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Return
                upgrade information.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/campaigns/firmware/{acc}')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FirmwareCampaign.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()

    def update_campaign_firmware_devices(self,
                                         acc,
                                         campaign_id,
                                         body):
        """Does a PUT request to /campaigns/firmware/{acc}/{campaignId}.

        This endpoint allows user to Add or Remove devices to an existing
        campaign.

        Args:
            acc (str): Account identifier.
            campaign_id (str): Unique identifier of a campaign.
            body (V3AddOrRemoveDeviceRequest): Add or remove device to
                existing upgrade information.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Returns
                add or remove devices to existing upgrade information.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/campaigns/firmware/{acc}/{campaignId}')
            .http_method(HttpMethodEnum.PUT)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('campaignId')
                            .value(campaign_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(V3AddOrRemoveDeviceResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()

    def update_campaign_dates(self,
                              acc,
                              campaign_id,
                              body):
        """Does a PUT request to /campaigns/firmware/{acc}/{campaignId}/dates.

        This endpoint allows user to change campaign dates and time windows.
        Fields which need to remain unchanged should be also provided.

        Args:
            acc (str): Account identifier.
            campaign_id (str): Firmware upgrade information.
            body (V3ChangeCampaignDatesRequest): New dates and time windows.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Updated
                campaign information.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/campaigns/firmware/{acc}/{campaignId}/dates')
            .http_method(HttpMethodEnum.PUT)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('campaignId')
                            .value(campaign_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FirmwareCampaign.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()

    def get_campaign_information(self,
                                 acc,
                                 campaign_id):
        """Does a GET request to /campaigns/{acc}/{campaignId}.

        This endpoint allows the user to retrieve campaign level information
        for a specified campaign.

        Args:
            acc (str): Account identifier.
            campaign_id (str): Firmware upgrade identifier.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Returns
                firmware upgrade information.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/campaigns/{acc}/{campaignId}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('campaignId')
                            .value(campaign_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(Campaign.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()

    def cancel_campaign(self,
                        acc,
                        campaign_id):
        """Does a DELETE request to /campaigns/{acc}/{campaignId}.

        This endpoint allows user to cancel a firmware campaign. A firmware
        campaign already started can not be cancelled.

        Args:
            acc (str): Account identifier.
            campaign_id (str): Firmware upgrade information.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Returns
                cancellation status.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V3)
            .path('/campaigns/{acc}/{campaignId}')
            .http_method(HttpMethodEnum.DELETE)
            .template_param(Parameter()
                            .key('acc')
                            .value(acc)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('campaignId')
                            .value(campaign_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FotaV3SuccessResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV3ResultException)
        ).execute()
