# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.and_auth_group import And
from verizon.models.trigger_v2_response import TriggerV2Response
from verizon.exceptions.rules_engine_rest_error_response_exception import RulesEngineRestErrorResponseException


class MV2TriggersController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(MV2TriggersController, self).__init__(config)

    def create_trigger(self,
                       body):
        """Does a POST request to /m2m/v2/triggers.

        This creates an individual change plan for account group share.

        Args:
            body (CreateTriggerV2Request): TODO: type description here.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Trigger
                ID

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v2/triggers')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TriggerV2Response.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Error Response', RulesEngineRestErrorResponseException)
        ).execute()

    def update_trigger(self,
                       vz_m2m_token,
                       body,
                       x_request_id=None):
        """Does a PUT request to /m2m/v2/triggers.

        This updates an individual change plan for account group share.

        Args:
            vz_m2m_token (str): M2M-MC Session Token
            body (UpdateTriggerV2Request): TODO: type description here.
            x_request_id (str, optional): Transaction Id

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Trigger
                ID

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v2/triggers')
            .http_method(HttpMethodEnum.PUT)
            .header_param(Parameter()
                          .key('VZ-M2M-Token')
                          .value(vz_m2m_token))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('X-Request-ID')
                          .value(x_request_id))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TriggerV2Response.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Error Response', RulesEngineRestErrorResponseException)
        ).execute()
