# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.and_auth_group import And
from verizon.models.registered_callbacks import RegisteredCallbacks
from verizon.models.fota_v1_callback_registration_result import FotaV1CallbackRegistrationResult
from verizon.models.fota_v1_success_result import FotaV1SuccessResult
from verizon.exceptions.fota_v1_result_exception import FotaV1ResultException


class SoftwareManagementCallbacksV1Controller(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(SoftwareManagementCallbacksV1Controller, self).__init__(config)

    def list_registered_callbacks(self,
                                  account):
        """Does a GET request to /callbacks/{account}.

        Returns the name and endpoint URL of the callback listening services
        registered for a given account.

        Args:
            account (str): Account identifier in "##########-#####".

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. List of
                callbacks.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/callbacks/{account}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RegisteredCallbacks.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()

    def register_callback(self,
                          account,
                          body):
        """Does a POST request to /callbacks/{account}.

        Registers a URL to receive RESTful messages from a callback service
        when new firmware versions are available and when upgrades start and
        finish.

        Args:
            account (str): Account identifier in "##########-#####".
            body (FotaV1CallbackRegistrationRequest): Callback details.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Result of
                registering a callback.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/callbacks/{account}')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FotaV1CallbackRegistrationResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()

    def deregister_callback(self,
                            account,
                            service):
        """Does a DELETE request to /callbacks/{account}/name/{service}.

        Deregisters the callback endpoint and stops ThingSpace from sending
        FOTA callback messages for the specified account.

        Args:
            account (str): Account identifier in "##########-#####".
            service (CallbackServiceEnum): Callback type. Must be 'Fota' for
                Software Management Services API.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Callback
                successfully deregistered.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/callbacks/{account}/name/{service}')
            .http_method(HttpMethodEnum.DELETE)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('service')
                            .value(service)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FotaV1SuccessResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()
