# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.device_id import DeviceId


class AddDevicesResult(object):

    """Implementation of the 'AddDevicesResult' model.

    Contains the device identifiers and a success or failure response for each
    device in the request.

    Attributes:
        device_ids (List[DeviceId]): Identifiers for the device.
        response (str): The success message or error message for the current
            device.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_ids": 'deviceIds',
        "response": 'response'
    }

    _optionals = [
        'device_ids',
        'response',
    ]

    def __init__(self,
                 device_ids=APIHelper.SKIP,
                 response=APIHelper.SKIP):
        """Constructor for the AddDevicesResult class"""

        # Initialize members of the class
        if device_ids is not APIHelper.SKIP:
            self.device_ids = device_ids 
        if response is not APIHelper.SKIP:
            self.response = response 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_ids = None
        if dictionary.get('deviceIds') is not None:
            device_ids = [DeviceId.from_dictionary(x) for x in dictionary.get('deviceIds')]
        else:
            device_ids = APIHelper.SKIP
        response = dictionary.get("response") if dictionary.get("response") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_ids,
                   response)
