# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.service_usage import ServiceUsage


class BillableUsageReport(object):

    """Implementation of the 'BillableUsageReport' model.

    Bill usage report.

    Attributes:
        account_name (str): Account identifier.
        usage_for_all_accounts (bool): The usage is for a single or multiple
            accounts.
        sku_name (str): SKU Name of the service subscription.
        transactions_allowed (str): The number of location requests included
            with the subscription type.
        total_transaction_count (str): The total number of billable device
            location requests during the reporting period from all included
            accounts.
        primary_account (ServiceUsage): TODO: type description here.
        managed_accounts (List[ServiceUsage]): Zero or more managed accounts.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "usage_for_all_accounts": 'usageForAllAccounts',
        "sku_name": 'skuName',
        "transactions_allowed": 'transactionsAllowed',
        "total_transaction_count": 'totalTransactionCount',
        "primary_account": 'PrimaryAccount',
        "managed_accounts": 'ManagedAccounts'
    }

    _optionals = [
        'account_name',
        'usage_for_all_accounts',
        'sku_name',
        'transactions_allowed',
        'total_transaction_count',
        'primary_account',
        'managed_accounts',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 usage_for_all_accounts=APIHelper.SKIP,
                 sku_name=APIHelper.SKIP,
                 transactions_allowed=APIHelper.SKIP,
                 total_transaction_count=APIHelper.SKIP,
                 primary_account=APIHelper.SKIP,
                 managed_accounts=APIHelper.SKIP):
        """Constructor for the BillableUsageReport class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if usage_for_all_accounts is not APIHelper.SKIP:
            self.usage_for_all_accounts = usage_for_all_accounts 
        if sku_name is not APIHelper.SKIP:
            self.sku_name = sku_name 
        if transactions_allowed is not APIHelper.SKIP:
            self.transactions_allowed = transactions_allowed 
        if total_transaction_count is not APIHelper.SKIP:
            self.total_transaction_count = total_transaction_count 
        if primary_account is not APIHelper.SKIP:
            self.primary_account = primary_account 
        if managed_accounts is not APIHelper.SKIP:
            self.managed_accounts = managed_accounts 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        usage_for_all_accounts = dictionary.get("usageForAllAccounts") if "usageForAllAccounts" in dictionary.keys() else APIHelper.SKIP
        sku_name = dictionary.get("skuName") if dictionary.get("skuName") else APIHelper.SKIP
        transactions_allowed = dictionary.get("transactionsAllowed") if dictionary.get("transactionsAllowed") else APIHelper.SKIP
        total_transaction_count = dictionary.get("totalTransactionCount") if dictionary.get("totalTransactionCount") else APIHelper.SKIP
        primary_account = ServiceUsage.from_dictionary(dictionary.get('PrimaryAccount')) if 'PrimaryAccount' in dictionary.keys() else APIHelper.SKIP
        managed_accounts = None
        if dictionary.get('ManagedAccounts') is not None:
            managed_accounts = [ServiceUsage.from_dictionary(x) for x in dictionary.get('ManagedAccounts')]
        else:
            managed_accounts = APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   usage_for_all_accounts,
                   sku_name,
                   transactions_allowed,
                   total_transaction_count,
                   primary_account,
                   managed_accounts)
