# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class CallbackRegistrationRequest(object):

    """Implementation of the 'CallbackRegistrationRequest' model.

    Specifies the callback service that is being subscribed to and the URL
    where the listening service is running.

    Attributes:
        account_name (str): The name of the billing account for which callback
            messages will be sent. Format: "##########-#####".
        service_name (str): The name of the callback service, which identifies
            the type and format of messages that will be sent to the
            registered URL.
        endpoint (str): The URL for your web server.
        http_headers (object): Your HTTP headers.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "service_name": 'serviceName',
        "endpoint": 'endpoint',
        "http_headers": 'httpHeaders'
    }

    _optionals = [
        'http_headers',
    ]

    def __init__(self,
                 account_name=None,
                 service_name=None,
                 endpoint=None,
                 http_headers=APIHelper.SKIP):
        """Constructor for the CallbackRegistrationRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.service_name = service_name 
        self.endpoint = endpoint 
        if http_headers is not APIHelper.SKIP:
            self.http_headers = http_headers 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        service_name = dictionary.get("serviceName") if dictionary.get("serviceName") else None
        endpoint = dictionary.get("endpoint") if dictionary.get("endpoint") else None
        http_headers = dictionary.get("httpHeaders") if dictionary.get("httpHeaders") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   service_name,
                   endpoint,
                   http_headers)
