# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_identifier import AccountIdentifier
from verizon.models.create_target_request_fields import CreateTargetRequestFields
from verizon.models.target_authentication import TargetAuthentication


class CreateTargetRequest(object):

    """Implementation of the 'CreateTargetRequest' model.

    Details of the target that you want to create.

    Attributes:
        accountidentifier (AccountIdentifier): The ID of the authenticating
            billing account, in the format
            `{"billingaccountid":"1234567890-12345"}`.
        billingaccountid (str): The ID of the authenticating billing account.
        kind (str): Identifies the resource kind. Targets are ts.target.
        address (str): The endpoint for notifications or data streams. The
            format depends on the selected `addressscheme`.<br />`streamrest`
            requires a `host:port` value <br />`streamawsiot` requres a valid
            ARN.
        addressscheme (str): The transport format. Valid values are: <br
            />streamawsiot - streamed data to an AWS account <br />streamrest
            - streamed REST data to a defined endpoint.
        fields (CreateTargetRequestFields): TODO: type description here.
        description (str): Descriptive information about the target.
        externalid (str): Security identification string created by a POST
            /targets/actions/newextid request.
        name (str): Name of the target.
        region (str): AWS region value.
        key_1 (str): OAuth 2.0 bearer token.
        oauth (TargetAuthentication): OAuth 2 token and refresh token for TS
            to stream events to Target.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "accountidentifier": 'accountidentifier',
        "billingaccountid": 'billingaccountid',
        "kind": 'kind',
        "address": 'address',
        "addressscheme": 'addressscheme',
        "fields": 'fields',
        "description": 'description',
        "externalid": 'externalid',
        "name": 'name',
        "region": 'region',
        "key_1": 'key1',
        "oauth": 'oauth'
    }

    _optionals = [
        'accountidentifier',
        'billingaccountid',
        'kind',
        'address',
        'addressscheme',
        'fields',
        'description',
        'externalid',
        'name',
        'region',
        'key_1',
        'oauth',
    ]

    def __init__(self,
                 accountidentifier=APIHelper.SKIP,
                 billingaccountid=APIHelper.SKIP,
                 kind=APIHelper.SKIP,
                 address=APIHelper.SKIP,
                 addressscheme=APIHelper.SKIP,
                 fields=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 externalid=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 region=APIHelper.SKIP,
                 key_1=APIHelper.SKIP,
                 oauth=APIHelper.SKIP):
        """Constructor for the CreateTargetRequest class"""

        # Initialize members of the class
        if accountidentifier is not APIHelper.SKIP:
            self.accountidentifier = accountidentifier 
        if billingaccountid is not APIHelper.SKIP:
            self.billingaccountid = billingaccountid 
        if kind is not APIHelper.SKIP:
            self.kind = kind 
        if address is not APIHelper.SKIP:
            self.address = address 
        if addressscheme is not APIHelper.SKIP:
            self.addressscheme = addressscheme 
        if fields is not APIHelper.SKIP:
            self.fields = fields 
        if description is not APIHelper.SKIP:
            self.description = description 
        if externalid is not APIHelper.SKIP:
            self.externalid = externalid 
        if name is not APIHelper.SKIP:
            self.name = name 
        if region is not APIHelper.SKIP:
            self.region = region 
        if key_1 is not APIHelper.SKIP:
            self.key_1 = key_1 
        if oauth is not APIHelper.SKIP:
            self.oauth = oauth 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        accountidentifier = AccountIdentifier.from_dictionary(dictionary.get('accountidentifier')) if 'accountidentifier' in dictionary.keys() else APIHelper.SKIP
        billingaccountid = dictionary.get("billingaccountid") if dictionary.get("billingaccountid") else APIHelper.SKIP
        kind = dictionary.get("kind") if dictionary.get("kind") else APIHelper.SKIP
        address = dictionary.get("address") if dictionary.get("address") else APIHelper.SKIP
        addressscheme = dictionary.get("addressscheme") if dictionary.get("addressscheme") else APIHelper.SKIP
        fields = CreateTargetRequestFields.from_dictionary(dictionary.get('fields')) if 'fields' in dictionary.keys() else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        externalid = dictionary.get("externalid") if dictionary.get("externalid") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        region = dictionary.get("region") if dictionary.get("region") else APIHelper.SKIP
        key_1 = dictionary.get("key1") if dictionary.get("key1") else APIHelper.SKIP
        oauth = TargetAuthentication.from_dictionary(dictionary.get('oauth')) if 'oauth' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(accountidentifier,
                   billingaccountid,
                   kind,
                   address,
                   addressscheme,
                   fields,
                   description,
                   externalid,
                   name,
                   region,
                   key_1,
                   oauth)
