# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.models.account_device_list import AccountDeviceList


class DeviceActivationRequest(object):

    """Implementation of the 'DeviceActivationRequest' model.

    Request for device status to check availability of activation.

    Attributes:
        account_name (str): The name of a billing account.
        devices (List[AccountDeviceList]): Up to 10,000 devices that you want
            to move to a different account, specified by device identifier.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "devices": 'devices'
    }

    def __init__(self,
                 account_name=None,
                 devices=None):
        """Constructor for the DeviceActivationRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.devices = devices 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        devices = None
        if dictionary.get('devices') is not None:
            devices = [AccountDeviceList.from_dictionary(x) for x in dictionary.get('devices')]
        # Return an object of this model
        return cls(account_name,
                   devices)
