# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class DeviceDiagnosticsCallback(object):

    """Implementation of the 'DeviceDiagnosticsCallback' model.

    Callback information of an existing diagnostics subscription.

    Attributes:
        account_name (str): The name of the billing account for which callback
            messages will be sent. Format: "##########-#####".
        service_name (str): The name of the callback service, which identifies
            the type and format of messages that will be sent to the
            registered URL.
        endpoint (str): The URL for your web server.
        created_on (datetime): The date and time of when this request was
            created.
        http_headers (object): Your HTTP headers.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "service_name": 'serviceName',
        "endpoint": 'endpoint',
        "created_on": 'createdOn',
        "http_headers": 'httpHeaders'
    }

    _optionals = [
        'http_headers',
    ]

    def __init__(self,
                 account_name=None,
                 service_name=None,
                 endpoint=None,
                 created_on=None,
                 http_headers=APIHelper.SKIP):
        """Constructor for the DeviceDiagnosticsCallback class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.service_name = service_name 
        self.endpoint = endpoint 
        self.created_on = APIHelper.apply_datetime_converter(created_on, APIHelper.RFC3339DateTime) if created_on else None 
        if http_headers is not APIHelper.SKIP:
            self.http_headers = http_headers 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        service_name = dictionary.get("serviceName") if dictionary.get("serviceName") else None
        endpoint = dictionary.get("endpoint") if dictionary.get("endpoint") else None
        created_on = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdOn")).datetime if dictionary.get("createdOn") else None
        http_headers = dictionary.get("httpHeaders") if dictionary.get("httpHeaders") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   service_name,
                   endpoint,
                   created_on,
                   http_headers)
