# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.device_firmware_version import DeviceFirmwareVersion


class DeviceFirmwareList(object):

    """Implementation of the 'DeviceFirmwareList' model.

    Device Firmware Information.

    Attributes:
        account_name (str): Account name.
        device_firmwar_version_list (List[DeviceFirmwareVersion]): List of
            device & firmware.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "device_firmwar_version_list": 'deviceFirmwarVersionList'
    }

    _optionals = [
        'device_firmwar_version_list',
    ]

    def __init__(self,
                 account_name=None,
                 device_firmwar_version_list=APIHelper.SKIP):
        """Constructor for the DeviceFirmwareList class"""

        # Initialize members of the class
        self.account_name = account_name 
        if device_firmwar_version_list is not APIHelper.SKIP:
            self.device_firmwar_version_list = device_firmwar_version_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        device_firmwar_version_list = None
        if dictionary.get('deviceFirmwarVersionList') is not None:
            device_firmwar_version_list = [DeviceFirmwareVersion.from_dictionary(x) for x in dictionary.get('deviceFirmwarVersionList')]
        else:
            device_firmwar_version_list = APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   device_firmwar_version_list)
