# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class ListServiceProfilesResult(object):

    """Implementation of the 'ListServiceProfilesResult' model.

    Response on successful retrieval of service profiles.

    Attributes:
        status (str): HTTP status code.
        data (List[str]): A comma delimited list of all the service profiles
            registered under your API key.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "status": 'status',
        "data": 'data'
    }

    _optionals = [
        'status',
        'data',
    ]

    def __init__(self,
                 status=APIHelper.SKIP,
                 data=APIHelper.SKIP):
        """Constructor for the ListServiceProfilesResult class"""

        # Initialize members of the class
        if status is not APIHelper.SKIP:
            self.status = status 
        if data is not APIHelper.SKIP:
            self.data = data 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        data = dictionary.get("data") if dictionary.get("data") else APIHelper.SKIP
        # Return an object of this model
        return cls(status,
                   data)
