# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class SessionReportRequest(object):

    """Implementation of the 'SessionReportRequest' model.

    Request for obtaining a session report.

    Attributes:
        account_number (str): Account Number.
        imei (str): Device ids.
        start_date (str): Start date of session to include. If not specified 
            information will be shown from the earliest available (180 days).
            Can be either date in ISO 8601 format or predefined constants.
        end_date (str): End date of session to include. If not specified 
            information will be shown to the latest available. Can be either
            date in ISO 8601 format or predefined constants.
        duration_low (int): The Low value of session duration.
        duration_high (int): The High value of session duration.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_number": 'accountNumber',
        "imei": 'imei',
        "start_date": 'startDate',
        "end_date": 'endDate',
        "duration_low": 'durationLow',
        "duration_high": 'durationHigh'
    }

    _optionals = [
        'start_date',
        'end_date',
        'duration_low',
        'duration_high',
    ]

    _nullables = [
        'duration_low',
        'duration_high',
    ]

    def __init__(self,
                 account_number=None,
                 imei=None,
                 start_date=APIHelper.SKIP,
                 end_date=APIHelper.SKIP,
                 duration_low=APIHelper.SKIP,
                 duration_high=APIHelper.SKIP):
        """Constructor for the SessionReportRequest class"""

        # Initialize members of the class
        self.account_number = account_number 
        self.imei = imei 
        if start_date is not APIHelper.SKIP:
            self.start_date = start_date 
        if end_date is not APIHelper.SKIP:
            self.end_date = end_date 
        if duration_low is not APIHelper.SKIP:
            self.duration_low = duration_low 
        if duration_high is not APIHelper.SKIP:
            self.duration_high = duration_high 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else None
        imei = dictionary.get("imei") if dictionary.get("imei") else None
        start_date = dictionary.get("startDate") if dictionary.get("startDate") else APIHelper.SKIP
        end_date = dictionary.get("endDate") if dictionary.get("endDate") else APIHelper.SKIP
        duration_low = dictionary.get("durationLow") if "durationLow" in dictionary.keys() else APIHelper.SKIP
        duration_high = dictionary.get("durationHigh") if "durationHigh" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(account_number,
                   imei,
                   start_date,
                   end_date,
                   duration_low,
                   duration_high)
