# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.v2_campaign_meta_info import V2CampaignMetaInfo


class V2CampaignHistory(object):

    """Implementation of the 'V2CampaignHistory' model.

    Campaign history details.

    Attributes:
        has_more_data (bool): Has more report flag.
        last_seen_campaign_id (str): Campaign identifier.
        campaign_list (List[V2CampaignMetaInfo]): Software upgrade list.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "has_more_data": 'hasMoreData',
        "campaign_list": 'campaignList',
        "last_seen_campaign_id": 'lastSeenCampaignId'
    }

    _optionals = [
        'last_seen_campaign_id',
    ]

    _nullables = [
        'campaign_list',
    ]

    def __init__(self,
                 has_more_data=None,
                 campaign_list=None,
                 last_seen_campaign_id=APIHelper.SKIP):
        """Constructor for the V2CampaignHistory class"""

        # Initialize members of the class
        self.has_more_data = has_more_data 
        if last_seen_campaign_id is not APIHelper.SKIP:
            self.last_seen_campaign_id = last_seen_campaign_id 
        self.campaign_list = campaign_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        has_more_data = dictionary.get("hasMoreData") if "hasMoreData" in dictionary.keys() else None
        campaign_list = None
        if dictionary.get('campaignList') is not None:
            campaign_list = [V2CampaignMetaInfo.from_dictionary(x) for x in dictionary.get('campaignList')]
        last_seen_campaign_id = dictionary.get("lastSeenCampaignId") if dictionary.get("lastSeenCampaignId") else APIHelper.SKIP
        # Return an object of this model
        return cls(has_more_data,
                   campaign_list,
                   last_seen_campaign_id)
