# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.models.v3_device_list_item import V3DeviceListItem


class V3AddOrRemoveDeviceResult(object):

    """Implementation of the 'V3AddOrRemoveDeviceResult' model.

    Add or remove devices to existing upgrade information.

    Attributes:
        account_name (str): Account identifier.
        campaign_id (str): Campaign identifier.
        device_list (List[V3DeviceListItem]): Array of devices changed.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "campaign_id": 'campaignId',
        "device_list": 'deviceList'
    }

    def __init__(self,
                 account_name=None,
                 campaign_id=None,
                 device_list=None):
        """Constructor for the V3AddOrRemoveDeviceResult class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.campaign_id = campaign_id 
        self.device_list = device_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        campaign_id = dictionary.get("campaignId") if dictionary.get("campaignId") else None
        device_list = None
        if dictionary.get('deviceList') is not None:
            device_list = [V3DeviceListItem.from_dictionary(x) for x in dictionary.get('deviceList')]
        # Return an object of this model
        return cls(account_name,
                   campaign_id,
                   device_list)
