# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from deprecation import deprecated
from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.and_auth_group import And
from verizon.models.v1_licenses_assigned_removed_result import V1LicensesAssignedRemovedResult
from verizon.models.v1_list_of_licenses_to_remove_result import V1ListOfLicensesToRemoveResult
from verizon.models.fota_v1_success_result import FotaV1SuccessResult
from verizon.models.v1_list_of_licenses_to_remove import V1ListOfLicensesToRemove
from verizon.exceptions.fota_v1_result_exception import FotaV1ResultException


class SoftwareManagementLicensesV1Controller(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(SoftwareManagementLicensesV1Controller, self).__init__(config)

    @deprecated()
    def assign_licenses_to_devices(self,
                                   account,
                                   body):
        """Does a POST request to /licenses/{account}/assign.

        Assigns licenses to a specified list of devices so that firmware
        upgrades can be scheduled for those devices.

        Args:
            account (str): Account identifier in "##########-#####".
            body (V1LicensesAssignedRemovedRequest): IMEIs of the devices to
                assign licenses to.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. List of
                licenses assigned.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/licenses/{account}/assign')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(V1LicensesAssignedRemovedResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()

    @deprecated()
    def remove_licenses_from_devices(self,
                                     account,
                                     body):
        """Does a POST request to /licenses/{account}/remove.

        Remove unused licenses from device.

        Args:
            account (str): Account identifier in "##########-#####".
            body (V1LicensesAssignedRemovedRequest): IMEIs of the devices to
                remove licenses from.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. List of
                devices with license removal status.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/licenses/{account}/remove')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(V1LicensesAssignedRemovedResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()

    @deprecated()
    def create_list_of_licenses_to_remove(self,
                                          account,
                                          body):
        """Does a POST request to /licenses/{account}/cancel.

        Creates a list of devices from which licenses will be removed if the
        number of MRC licenses becomes less than the number of assigned
        licenses.

        Args:
            account (str): Account identifier in "##########-#####".
            body (V1ListOfLicensesToRemoveRequest): Cancellation candidate
                device list.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. List of
                licenses assigned.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/licenses/{account}/cancel')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(V1ListOfLicensesToRemoveResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()

    @deprecated()
    def delete_list_of_licenses_to_remove(self,
                                          account):
        """Does a DELETE request to /licenses/{account}/cancel.

        Deletes the entire list of cancellation candidate devices.

        Args:
            account (str): Account identifier in "##########-#####".

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Upgrade
                canceled.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/licenses/{account}/cancel')
            .http_method(HttpMethodEnum.DELETE)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FotaV1SuccessResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()

    @deprecated()
    def list_licenses_to_remove(self,
                                account,
                                start_index):
        """Does a GET request to /licenses/{account}/cancel/index/{startIndex}.

        Returns a list of devices from which licenses will be removed if the
        number of MRC licenses becomes less than the number of assigned
        licenses.

        Args:
            account (str): Account identifier in "##########-#####".
            start_index (str): The zero-based number of the first record to
                return. Set startIndex=0 for the first request. If there are
                more than 1,000 devices in the response, set startIndex=1000
                for the second request, 2000 for the third request, etc.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. List of
                cancellation candidate devices.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/licenses/{account}/cancel/index/{startIndex}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('startIndex')
                            .value(start_index)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(And(Single('thingspace_oauth'), Single('VZ-M2M-Token')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(V1ListOfLicensesToRemove.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()
