# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.i_error_message import IErrorMessage


class AggregateUsageError(object):

    """Implementation of the 'AggregateUsageError' model.

    Error reported by a device.

    Attributes:
        imei (str): International Mobile Equipment Identifier. This is the ID
            of the device reporting errors.
        error_message (str): A general error message.
        error_response (IErrorMessage): Error message.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "imei": 'imei',
        "error_message": 'errorMessage',
        "error_response": 'errorResponse'
    }

    _optionals = [
        'imei',
        'error_message',
        'error_response',
    ]

    def __init__(self,
                 imei=APIHelper.SKIP,
                 error_message=APIHelper.SKIP,
                 error_response=APIHelper.SKIP):
        """Constructor for the AggregateUsageError class"""

        # Initialize members of the class
        if imei is not APIHelper.SKIP:
            self.imei = imei 
        if error_message is not APIHelper.SKIP:
            self.error_message = error_message 
        if error_response is not APIHelper.SKIP:
            self.error_response = error_response 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        imei = dictionary.get("imei") if dictionary.get("imei") else APIHelper.SKIP
        error_message = dictionary.get("errorMessage") if dictionary.get("errorMessage") else APIHelper.SKIP
        error_response = IErrorMessage.from_dictionary(dictionary.get('errorResponse')) if 'errorResponse' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(imei,
                   error_message,
                   error_response)
