# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.sensitivity_parameters import SensitivityParameters


class AnomalyDetectionRequest(object):

    """Implementation of the 'AnomalyDetectionRequest' model.

    Anomaly detection request.

    Attributes:
        account_name (str): The name of a billing account. An account name is
            usually numeric, and must include any leading zeros.
        request_type (str): The type of request being made. anomaly is the
            request to activate anomaly detection.
        sensitivity_parameter (SensitivityParameters): Details for sensitivity
            parameters.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "request_type": 'requestType',
        "sensitivity_parameter": 'sensitivityParameter'
    }

    _optionals = [
        'account_name',
        'request_type',
        'sensitivity_parameter',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 request_type=APIHelper.SKIP,
                 sensitivity_parameter=APIHelper.SKIP):
        """Constructor for the AnomalyDetectionRequest class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if request_type is not APIHelper.SKIP:
            self.request_type = request_type 
        if sensitivity_parameter is not APIHelper.SKIP:
            self.sensitivity_parameter = sensitivity_parameter 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        request_type = dictionary.get("requestType") if dictionary.get("requestType") else APIHelper.SKIP
        sensitivity_parameter = SensitivityParameters.from_dictionary(dictionary.get('sensitivityParameter')) if 'sensitivityParameter' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   request_type,
                   sensitivity_parameter)
