# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_device_list import AccountDeviceList
from verizon.models.custom_fields import CustomFields


class CarrierDeactivateRequest(object):

    """Implementation of the 'CarrierDeactivateRequest' model.

    Request to deactivate a carrier.

    Attributes:
        account_name (str): The name of a billing account.
        devices (List[AccountDeviceList]): The devices for which you want to
            deactivate service, specified by device identifier.
        reason_code (str): Code identifying the reason for the deactivation.
            Currently the only valid reason code is “FF”, which corresponds to
            General Admin/Maintenance.
        custom_fields (List[CustomFields]): Custom field names and values, if
            you want to only include devices that have matching values.
        etf_waiver (bool): Fees may be assessed for deactivating Verizon
            Wireless devices, depending on the account contract. The etfWaiver
            parameter waives the Early Termination Fee (ETF), if applicable.
        group_name (str): The name of a device group, if you want to
            deactivate all devices in that group.
        service_plan (str): The name of a service plan, if you want to only
            include devices that have that service plan.
        delete_after_deactivation (bool): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "devices": 'devices',
        "reason_code": 'reasonCode',
        "custom_fields": 'customFields',
        "etf_waiver": 'etfWaiver',
        "group_name": 'groupName',
        "service_plan": 'servicePlan',
        "delete_after_deactivation": 'deleteAfterDeactivation'
    }

    _optionals = [
        'custom_fields',
        'etf_waiver',
        'group_name',
        'service_plan',
        'delete_after_deactivation',
    ]

    def __init__(self,
                 account_name=None,
                 devices=None,
                 reason_code=None,
                 custom_fields=APIHelper.SKIP,
                 etf_waiver=APIHelper.SKIP,
                 group_name=APIHelper.SKIP,
                 service_plan=APIHelper.SKIP,
                 delete_after_deactivation=APIHelper.SKIP):
        """Constructor for the CarrierDeactivateRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.devices = devices 
        self.reason_code = reason_code 
        if custom_fields is not APIHelper.SKIP:
            self.custom_fields = custom_fields 
        if etf_waiver is not APIHelper.SKIP:
            self.etf_waiver = etf_waiver 
        if group_name is not APIHelper.SKIP:
            self.group_name = group_name 
        if service_plan is not APIHelper.SKIP:
            self.service_plan = service_plan 
        if delete_after_deactivation is not APIHelper.SKIP:
            self.delete_after_deactivation = delete_after_deactivation 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        devices = None
        if dictionary.get('devices') is not None:
            devices = [AccountDeviceList.from_dictionary(x) for x in dictionary.get('devices')]
        reason_code = dictionary.get("reasonCode") if dictionary.get("reasonCode") else None
        custom_fields = None
        if dictionary.get('customFields') is not None:
            custom_fields = [CustomFields.from_dictionary(x) for x in dictionary.get('customFields')]
        else:
            custom_fields = APIHelper.SKIP
        etf_waiver = dictionary.get("etfWaiver") if "etfWaiver" in dictionary.keys() else APIHelper.SKIP
        group_name = dictionary.get("groupName") if dictionary.get("groupName") else APIHelper.SKIP
        service_plan = dictionary.get("servicePlan") if dictionary.get("servicePlan") else APIHelper.SKIP
        delete_after_deactivation = dictionary.get("deleteAfterDeactivation") if "deleteAfterDeactivation" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   devices,
                   reason_code,
                   custom_fields,
                   etf_waiver,
                   group_name,
                   service_plan,
                   delete_after_deactivation)
