# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.fields import Fields


class ChangeConfigurationResponse(object):

    """Implementation of the 'ChangeConfigurationResponse' model.

    Change Configuration resource definition.

    Attributes:
        action (str): The action requested in this event; “change” for device
            configuration changes.
        createdon (str): The date and time of the change request.
        deviceid (str): The device’s ThingSpace UUID.
        fields (Fields): List of fields affected by the event.
        foreignid (str): foreign id
        id (str): The unique ID of this ts.event.configuration event.
        kind (str): The kind of the ThingSpace resource that is being
            reported
        lastupdated (str): The date and time that the event was last updated.
        name (str): The name of the event; “SetConfigurationReq” for device
            configuration changes.
        state (str): The current status of the request. The value will be
            “pending” until the device wakes up and ThingSpace can send the
            request to the device.
        transactionid (str): transaction id
        version (str): version

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "action": 'action',
        "createdon": 'createdon',
        "deviceid": 'deviceid',
        "fields": 'fields',
        "foreignid": 'foreignid',
        "id": 'id',
        "kind": 'kind',
        "lastupdated": 'lastupdated',
        "name": 'name',
        "state": 'state',
        "transactionid": 'transactionid',
        "version": 'version'
    }

    _optionals = [
        'action',
        'createdon',
        'deviceid',
        'fields',
        'foreignid',
        'id',
        'kind',
        'lastupdated',
        'name',
        'state',
        'transactionid',
        'version',
    ]

    def __init__(self,
                 action=APIHelper.SKIP,
                 createdon=APIHelper.SKIP,
                 deviceid=APIHelper.SKIP,
                 fields=APIHelper.SKIP,
                 foreignid=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 kind=APIHelper.SKIP,
                 lastupdated=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 state=APIHelper.SKIP,
                 transactionid=APIHelper.SKIP,
                 version=APIHelper.SKIP):
        """Constructor for the ChangeConfigurationResponse class"""

        # Initialize members of the class
        if action is not APIHelper.SKIP:
            self.action = action 
        if createdon is not APIHelper.SKIP:
            self.createdon = createdon 
        if deviceid is not APIHelper.SKIP:
            self.deviceid = deviceid 
        if fields is not APIHelper.SKIP:
            self.fields = fields 
        if foreignid is not APIHelper.SKIP:
            self.foreignid = foreignid 
        if id is not APIHelper.SKIP:
            self.id = id 
        if kind is not APIHelper.SKIP:
            self.kind = kind 
        if lastupdated is not APIHelper.SKIP:
            self.lastupdated = lastupdated 
        if name is not APIHelper.SKIP:
            self.name = name 
        if state is not APIHelper.SKIP:
            self.state = state 
        if transactionid is not APIHelper.SKIP:
            self.transactionid = transactionid 
        if version is not APIHelper.SKIP:
            self.version = version 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        action = dictionary.get("action") if dictionary.get("action") else APIHelper.SKIP
        createdon = dictionary.get("createdon") if dictionary.get("createdon") else APIHelper.SKIP
        deviceid = dictionary.get("deviceid") if dictionary.get("deviceid") else APIHelper.SKIP
        fields = Fields.from_dictionary(dictionary.get('fields')) if 'fields' in dictionary.keys() else APIHelper.SKIP
        foreignid = dictionary.get("foreignid") if dictionary.get("foreignid") else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        kind = dictionary.get("kind") if dictionary.get("kind") else APIHelper.SKIP
        lastupdated = dictionary.get("lastupdated") if dictionary.get("lastupdated") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        state = dictionary.get("state") if dictionary.get("state") else APIHelper.SKIP
        transactionid = dictionary.get("transactionid") if dictionary.get("transactionid") else APIHelper.SKIP
        version = dictionary.get("version") if dictionary.get("version") else APIHelper.SKIP
        # Return an object of this model
        return cls(action,
                   createdon,
                   deviceid,
                   fields,
                   foreignid,
                   id,
                   kind,
                   lastupdated,
                   name,
                   state,
                   transactionid,
                   version)
