# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_device_list import AccountDeviceList
from verizon.models.place_of_use import PlaceOfUse


class ContactInfoUpdateRequest(object):

    """Implementation of the 'ContactInfoUpdateRequest' model.

    Request to update contact information.

    Attributes:
        primary_place_of_use (PlaceOfUse): The customer name and the address
            of the device's primary place of use. Leave these fields empty to
            use the account profile address as the primary place of use. These
            values will be applied to all devices in the request.If the
            account is enabled for non-geographic MDNs and the device supports
            it, the primaryPlaceOfUse address will also be used to derive the
            MDN for the device.
        account_name (str): The name of the billing account that the devices
            belong to. An account name is usually numeric, and must include
            any leading zeros.
        devices (List[AccountDeviceList]): A list of the devices that you want
            to change, specified by device identifier. You only need to
            provide one identifier per device. Do not include accountName,
            groupName, customFields, or servicePlan if you use this
            parameter.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "primary_place_of_use": 'primaryPlaceOfUse',
        "account_name": 'accountName',
        "devices": 'devices'
    }

    _optionals = [
        'account_name',
        'devices',
    ]

    def __init__(self,
                 primary_place_of_use=None,
                 account_name=APIHelper.SKIP,
                 devices=APIHelper.SKIP):
        """Constructor for the ContactInfoUpdateRequest class"""

        # Initialize members of the class
        self.primary_place_of_use = primary_place_of_use 
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if devices is not APIHelper.SKIP:
            self.devices = devices 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        primary_place_of_use = PlaceOfUse.from_dictionary(dictionary.get('primaryPlaceOfUse')) if dictionary.get('primaryPlaceOfUse') else None
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        devices = None
        if dictionary.get('devices') is not None:
            devices = [AccountDeviceList.from_dictionary(x) for x in dictionary.get('devices')]
        else:
            devices = APIHelper.SKIP
        # Return an object of this model
        return cls(primary_place_of_use,
                   account_name,
                   devices)
