# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class DeleteDevicesResult(object):

    """Implementation of the 'DeleteDevicesResult' model.

    Response for a request made to delete a device.

    Attributes:
        device_ids (object): One object per device to be deleted. Each object
            must contain a kind and id element identifying the device.
        status (str): “Success” if the device was deleted, or “Failed” if
            there was a problem.
        message (str): Not present if status=Success. One of these messages if
            status=Failed:The device is not in deactivate state.The user does
            not have access to delete the device.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_ids": 'deviceIds',
        "status": 'status',
        "message": 'message'
    }

    _optionals = [
        'device_ids',
        'status',
        'message',
    ]

    def __init__(self,
                 device_ids=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 message=APIHelper.SKIP):
        """Constructor for the DeleteDevicesResult class"""

        # Initialize members of the class
        if device_ids is not APIHelper.SKIP:
            self.device_ids = device_ids 
        if status is not APIHelper.SKIP:
            self.status = status 
        if message is not APIHelper.SKIP:
            self.message = message 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_ids = dictionary.get("deviceIds") if dictionary.get("deviceIds") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        message = dictionary.get("message") if dictionary.get("message") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_ids,
                   status,
                   message)
