# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class DeviceFirmwareVersion(object):

    """Implementation of the 'DeviceFirmwareVersion' model.

    Device and firmware information.

    Attributes:
        status (str): TODO: type description here.
        reason (str): TODO: type description here.
        device_id (str): Device IMEI.
        firmware_version (str): Device Firmware Version.
        firmware_version_update_time (datetime): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "firmware_version": 'firmwareVersion',
        "status": 'status',
        "reason": 'reason',
        "firmware_version_update_time": 'firmwareVersionUpdateTime'
    }

    _optionals = [
        'status',
        'reason',
        'firmware_version_update_time',
    ]

    def __init__(self,
                 device_id=None,
                 firmware_version=None,
                 status=APIHelper.SKIP,
                 reason=APIHelper.SKIP,
                 firmware_version_update_time=APIHelper.SKIP):
        """Constructor for the DeviceFirmwareVersion class"""

        # Initialize members of the class
        if status is not APIHelper.SKIP:
            self.status = status 
        if reason is not APIHelper.SKIP:
            self.reason = reason 
        self.device_id = device_id 
        self.firmware_version = firmware_version 
        if firmware_version_update_time is not APIHelper.SKIP:
            self.firmware_version_update_time = APIHelper.apply_datetime_converter(firmware_version_update_time, APIHelper.RFC3339DateTime) if firmware_version_update_time else None 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = dictionary.get("deviceId") if dictionary.get("deviceId") else None
        firmware_version = dictionary.get("firmwareVersion") if dictionary.get("firmwareVersion") else None
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        reason = dictionary.get("reason") if dictionary.get("reason") else APIHelper.SKIP
        firmware_version_update_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("firmwareVersionUpdateTime")).datetime if dictionary.get("firmwareVersionUpdateTime") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_id,
                   firmware_version,
                   status,
                   reason,
                   firmware_version_update_time)
