# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class DeviceLocationSubscription(object):

    """Implementation of the 'DeviceLocationSubscription' model.

    TODO: type model description here.

    Attributes:
        account_name (str): Account identifier in "##########-#####".
        loc_type (str): Location service license type.
        max_allowance (str): The number of billable location requests allowed
            per billing cycle.
        purchase_time (str): Location service purchase time.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "loc_type": 'locType',
        "max_allowance": 'maxAllowance',
        "purchase_time": 'purchaseTime'
    }

    _optionals = [
        'account_name',
        'loc_type',
        'max_allowance',
        'purchase_time',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 loc_type=APIHelper.SKIP,
                 max_allowance=APIHelper.SKIP,
                 purchase_time=APIHelper.SKIP):
        """Constructor for the DeviceLocationSubscription class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if loc_type is not APIHelper.SKIP:
            self.loc_type = loc_type 
        if max_allowance is not APIHelper.SKIP:
            self.max_allowance = max_allowance 
        if purchase_time is not APIHelper.SKIP:
            self.purchase_time = purchase_time 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        loc_type = dictionary.get("locType") if dictionary.get("locType") else APIHelper.SKIP
        max_allowance = dictionary.get("maxAllowance") if dictionary.get("maxAllowance") else APIHelper.SKIP
        purchase_time = dictionary.get("purchaseTime") if dictionary.get("purchaseTime") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   loc_type,
                   max_allowance,
                   purchase_time)
