# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class Firmware(object):

    """Implementation of the 'Firmware' model.

    Firmware information.

    Attributes:
        firmware_name (str): The name of the firmware image, provided by the
            device manufacturer.
        participant_name (str): Internal reference; can be ignored.
        launch_date (datetime): The release date of the firmware image.
        release_note (str): Additional information about the release.
        model (str): The device model that the firmware applies to.
        make (str): The device make that the firmware applies to.
        from_version (str): The firmware version that must currently be on the
            device to upgrade.
        to_version (str): The firmware version that will be on the device
            after an upgrade.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "firmware_name": 'firmwareName',
        "participant_name": 'participantName',
        "launch_date": 'launchDate',
        "release_note": 'releaseNote',
        "model": 'model',
        "make": 'make',
        "from_version": 'fromVersion',
        "to_version": 'toVersion'
    }

    _optionals = [
        'firmware_name',
        'participant_name',
        'launch_date',
        'release_note',
        'model',
        'make',
        'from_version',
        'to_version',
    ]

    def __init__(self,
                 firmware_name=APIHelper.SKIP,
                 participant_name=APIHelper.SKIP,
                 launch_date=APIHelper.SKIP,
                 release_note=APIHelper.SKIP,
                 model=APIHelper.SKIP,
                 make=APIHelper.SKIP,
                 from_version=APIHelper.SKIP,
                 to_version=APIHelper.SKIP):
        """Constructor for the Firmware class"""

        # Initialize members of the class
        if firmware_name is not APIHelper.SKIP:
            self.firmware_name = firmware_name 
        if participant_name is not APIHelper.SKIP:
            self.participant_name = participant_name 
        if launch_date is not APIHelper.SKIP:
            self.launch_date = APIHelper.apply_datetime_converter(launch_date, APIHelper.RFC3339DateTime) if launch_date else None 
        if release_note is not APIHelper.SKIP:
            self.release_note = release_note 
        if model is not APIHelper.SKIP:
            self.model = model 
        if make is not APIHelper.SKIP:
            self.make = make 
        if from_version is not APIHelper.SKIP:
            self.from_version = from_version 
        if to_version is not APIHelper.SKIP:
            self.to_version = to_version 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        firmware_name = dictionary.get("firmwareName") if dictionary.get("firmwareName") else APIHelper.SKIP
        participant_name = dictionary.get("participantName") if dictionary.get("participantName") else APIHelper.SKIP
        launch_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("launchDate")).datetime if dictionary.get("launchDate") else APIHelper.SKIP
        release_note = dictionary.get("releaseNote") if dictionary.get("releaseNote") else APIHelper.SKIP
        model = dictionary.get("model") if dictionary.get("model") else APIHelper.SKIP
        make = dictionary.get("make") if dictionary.get("make") else APIHelper.SKIP
        from_version = dictionary.get("fromVersion") if dictionary.get("fromVersion") else APIHelper.SKIP
        to_version = dictionary.get("toVersion") if dictionary.get("toVersion") else APIHelper.SKIP
        # Return an object of this model
        return cls(firmware_name,
                   participant_name,
                   launch_date,
                   release_note,
                   model,
                   make,
                   from_version,
                   to_version)
