# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class FirmwarePackage(object):

    """Implementation of the 'FirmwarePackage' model.

    Available firmware.

    Attributes:
        firmware_name (str): Firmware name.
        firmware_from (str): Firmware from version.
        firmware_to (str): Firmware to version.
        launch_date (datetime): Firmware launch date.
        release_note (str): Firmware release note.
        model (str): Firmware applicable device model.
        make (str): Firmware applicable device make.
        protocol (CampaignMetaInfoProtocolEnum): Firmware protocol. Valid
            values include: LWM2M, OMD-DM.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "firmware_name": 'firmwareName',
        "firmware_from": 'firmwareFrom',
        "firmware_to": 'firmwareTo',
        "launch_date": 'launchDate',
        "release_note": 'releaseNote',
        "model": 'model',
        "make": 'make',
        "protocol": 'protocol'
    }

    def __init__(self,
                 firmware_name=None,
                 firmware_from=None,
                 firmware_to=None,
                 launch_date=None,
                 release_note=None,
                 model=None,
                 make=None,
                 protocol='LWM2M'):
        """Constructor for the FirmwarePackage class"""

        # Initialize members of the class
        self.firmware_name = firmware_name 
        self.firmware_from = firmware_from 
        self.firmware_to = firmware_to 
        self.launch_date = APIHelper.apply_datetime_converter(launch_date, APIHelper.RFC3339DateTime) if launch_date else None 
        self.release_note = release_note 
        self.model = model 
        self.make = make 
        self.protocol = protocol 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        firmware_name = dictionary.get("firmwareName") if dictionary.get("firmwareName") else None
        firmware_from = dictionary.get("firmwareFrom") if dictionary.get("firmwareFrom") else None
        firmware_to = dictionary.get("firmwareTo") if dictionary.get("firmwareTo") else None
        launch_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("launchDate")).datetime if dictionary.get("launchDate") else None
        release_note = dictionary.get("releaseNote") if dictionary.get("releaseNote") else None
        model = dictionary.get("model") if dictionary.get("model") else None
        make = dictionary.get("make") if dictionary.get("make") else None
        protocol = dictionary.get("protocol") if dictionary.get("protocol") else 'LWM2M'
        # Return an object of this model
        return cls(firmware_name,
                   firmware_from,
                   firmware_to,
                   launch_date,
                   release_note,
                   model,
                   make,
                   protocol)
