# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.resources_edge_hosted_service import ResourcesEdgeHostedService


class ListOptimalServiceEndpointsResult(object):

    """Implementation of the 'ListOptimalServiceEndpointsResult' model.

    Response on successful retrieval of optimal service endpoints for
    clients.

    Attributes:
        service_endpoints (List[ResourcesEdgeHostedService]): An array of
            optimal Service Endpoint IDs for clients to connect to.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "service_endpoints": 'serviceEndpoints'
    }

    _optionals = [
        'service_endpoints',
    ]

    def __init__(self,
                 service_endpoints=APIHelper.SKIP):
        """Constructor for the ListOptimalServiceEndpointsResult class"""

        # Initialize members of the class
        if service_endpoints is not APIHelper.SKIP:
            self.service_endpoints = service_endpoints 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        service_endpoints = None
        if dictionary.get('serviceEndpoints') is not None:
            service_endpoints = [ResourcesEdgeHostedService.from_dictionary(x) for x in dictionary.get('serviceEndpoints')]
        else:
            service_endpoints = APIHelper.SKIP
        # Return an object of this model
        return cls(service_endpoints)
