# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.device_info import DeviceInfo


class LocationRequest(object):

    """Implementation of the 'LocationRequest' model.

    The body contains the the account name and list of devices that you want
    to locate, plus other options.

    Attributes:
        account_name (str): Account identifier in "##########-#####".
        device_list (List[DeviceInfo]): Device list.
        accuracy_mode (AccuracyModeEnum): Accurary, currently only 0-coarse
            supported.
        cache_mode (CacheModeEnum): Location cache mode.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "device_list": 'deviceList',
        "accuracy_mode": 'accuracyMode',
        "cache_mode": 'cacheMode'
    }

    _optionals = [
        'accuracy_mode',
        'cache_mode',
    ]

    def __init__(self,
                 account_name=None,
                 device_list=None,
                 accuracy_mode=APIHelper.SKIP,
                 cache_mode=APIHelper.SKIP):
        """Constructor for the LocationRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.device_list = device_list 
        if accuracy_mode is not APIHelper.SKIP:
            self.accuracy_mode = accuracy_mode 
        if cache_mode is not APIHelper.SKIP:
            self.cache_mode = cache_mode 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        device_list = None
        if dictionary.get('deviceList') is not None:
            device_list = [DeviceInfo.from_dictionary(x) for x in dictionary.get('deviceList')]
        accuracy_mode = dictionary.get("accuracyMode") if dictionary.get("accuracyMode") else APIHelper.SKIP
        cache_mode = dictionary.get("cacheMode") if dictionary.get("cacheMode") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   device_list,
                   accuracy_mode,
                   cache_mode)
