# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class MECPlatformResource(object):

    """Implementation of the 'MECPlatformResource' model.

    5G Edge platform used for deployment of a service. The ern of each
    platform contains the name of the matching AWS Wavelength zone that can be
    used when deploying.

    Attributes:
        ern (str): Edge Resource Name. A string identifier for a set of edge
            resources.
        zone (str): Unique identifier representing a zone. *Note:* This will
            have a null value as a placeholder.
        region (str): MEC region name. Current valid values are US_WEST_2 and
            US_EAST_1.
        status (MECPlatformStatusEnum): Status of the MEC Platform (default is
            'unknown')
        properties (object): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "ern": 'ern',
        "zone": 'zone',
        "region": 'region',
        "status": 'status',
        "properties": 'properties'
    }

    _optionals = [
        'ern',
        'zone',
        'region',
        'status',
        'properties',
    ]

    _nullables = [
        'zone',
    ]

    def __init__(self,
                 ern=APIHelper.SKIP,
                 zone=APIHelper.SKIP,
                 region=APIHelper.SKIP,
                 status='unknown',
                 properties=APIHelper.SKIP):
        """Constructor for the MECPlatformResource class"""

        # Initialize members of the class
        if ern is not APIHelper.SKIP:
            self.ern = ern 
        if zone is not APIHelper.SKIP:
            self.zone = zone 
        if region is not APIHelper.SKIP:
            self.region = region 
        self.status = status 
        if properties is not APIHelper.SKIP:
            self.properties = properties 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        ern = dictionary.get("ern") if dictionary.get("ern") else APIHelper.SKIP
        zone = dictionary.get("zone") if "zone" in dictionary.keys() else APIHelper.SKIP
        region = dictionary.get("region") if dictionary.get("region") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else 'unknown'
        properties = dictionary.get("properties") if dictionary.get("properties") else APIHelper.SKIP
        # Return an object of this model
        return cls(ern,
                   zone,
                   region,
                   status,
                   properties)
