# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class PositionError(object):

    """Implementation of the 'PositionError' model.

    Position error.

    Attributes:
        time (str): Time location obtained.
        utcoffset (str): UTC offset of time.
        mtype (str): Error type returned from location server.
        info (str): Additional information about the error.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "time": 'time',
        "utcoffset": 'utcoffset',
        "mtype": 'type',
        "info": 'info'
    }

    _optionals = [
        'time',
        'utcoffset',
        'mtype',
        'info',
    ]

    def __init__(self,
                 time=APIHelper.SKIP,
                 utcoffset=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 info=APIHelper.SKIP):
        """Constructor for the PositionError class"""

        # Initialize members of the class
        if time is not APIHelper.SKIP:
            self.time = time 
        if utcoffset is not APIHelper.SKIP:
            self.utcoffset = utcoffset 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if info is not APIHelper.SKIP:
            self.info = info 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        time = dictionary.get("time") if dictionary.get("time") else APIHelper.SKIP
        utcoffset = dictionary.get("utcoffset") if dictionary.get("utcoffset") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        info = dictionary.get("info") if dictionary.get("info") else APIHelper.SKIP
        # Return an object of this model
        return cls(time,
                   utcoffset,
                   mtype,
                   info)
