# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.gio_device_id import GIODeviceId


class SMSEventHistoryRequest(object):

    """Implementation of the 'SMSEventHistoryRequest' model.

    TODO: type model description here.

    Attributes:
        device_id (GIODeviceId): TODO: type description here.
        earliest (datetime): TODO: type description here.
        latest (datetime): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "earliest": 'earliest',
        "latest": 'latest'
    }

    _optionals = [
        'earliest',
        'latest',
    ]

    def __init__(self,
                 device_id=None,
                 earliest=APIHelper.SKIP,
                 latest=APIHelper.SKIP):
        """Constructor for the SMSEventHistoryRequest class"""

        # Initialize members of the class
        self.device_id = device_id 
        if earliest is not APIHelper.SKIP:
            self.earliest = APIHelper.apply_datetime_converter(earliest, APIHelper.RFC3339DateTime) if earliest else None 
        if latest is not APIHelper.SKIP:
            self.latest = APIHelper.apply_datetime_converter(latest, APIHelper.RFC3339DateTime) if latest else None 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = GIODeviceId.from_dictionary(dictionary.get('deviceId')) if dictionary.get('deviceId') else None
        earliest = APIHelper.RFC3339DateTime.from_value(dictionary.get("earliest")).datetime if dictionary.get("earliest") else APIHelper.SKIP
        latest = APIHelper.RFC3339DateTime.from_value(dictionary.get("latest")).datetime if dictionary.get("latest") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_id,
                   earliest,
                   latest)
