# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class Subscription(object):

    """Implementation of the 'Subscription' model.

    Subscription resource definition.

    Attributes:
        configurationfailures (int): The number of streaming failures due to
            faulty configuration.
        createdon (str): The number of streaming failures due to faulty
            configuration.
        delegateid (str): Not currently used.
        description (str): Description of the subscription.
        disabled (bool): Whether the subscription is currently sending data.
        email (str): The address to which any error reports should be
            delivered.
        filter (str): Filter for events.
        id (str): ThingSpace unique ID for the subscription that was created.
        kind (str): Identifies the resource kind.
        laststreamingstatus (str): Possible values: success or fail.
        laststreamingtime (str): The date and time that the last stream send
            was attempted.
        lastupdated (str): The date the resource was last updated.
        name (str): Name of the subscription.
        networkfailures (int): The number of failures due to network
            problems.
        streamfailures (int): TODO: type description here.
        streamkind (str): The event type that will be sent in the data
            stream.
        targetid (str): Target to be used for dispatching events.
        targettype (str): TODO: type description here.
        version (str): Version of the underlying schema resource.
        versionid (str): The version of the resource.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "configurationfailures": 'configurationfailures',
        "createdon": 'createdon',
        "delegateid": 'delegateid',
        "description": 'description',
        "disabled": 'disabled',
        "email": 'email',
        "filter": 'filter',
        "id": 'id',
        "kind": 'kind',
        "laststreamingstatus": 'laststreamingstatus',
        "laststreamingtime": 'laststreamingtime',
        "lastupdated": 'lastupdated',
        "name": 'name',
        "networkfailures": 'networkfailures',
        "streamfailures": 'streamfailures',
        "streamkind": 'streamkind',
        "targetid": 'targetid',
        "targettype": 'targettype',
        "version": 'version',
        "versionid": 'versionid'
    }

    _optionals = [
        'configurationfailures',
        'createdon',
        'delegateid',
        'description',
        'disabled',
        'email',
        'filter',
        'id',
        'kind',
        'laststreamingstatus',
        'laststreamingtime',
        'lastupdated',
        'name',
        'networkfailures',
        'streamfailures',
        'streamkind',
        'targetid',
        'targettype',
        'version',
        'versionid',
    ]

    def __init__(self,
                 configurationfailures=APIHelper.SKIP,
                 createdon=APIHelper.SKIP,
                 delegateid=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 disabled=APIHelper.SKIP,
                 email=APIHelper.SKIP,
                 filter=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 kind=APIHelper.SKIP,
                 laststreamingstatus=APIHelper.SKIP,
                 laststreamingtime=APIHelper.SKIP,
                 lastupdated=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 networkfailures=APIHelper.SKIP,
                 streamfailures=APIHelper.SKIP,
                 streamkind=APIHelper.SKIP,
                 targetid=APIHelper.SKIP,
                 targettype=APIHelper.SKIP,
                 version=APIHelper.SKIP,
                 versionid=APIHelper.SKIP):
        """Constructor for the Subscription class"""

        # Initialize members of the class
        if configurationfailures is not APIHelper.SKIP:
            self.configurationfailures = configurationfailures 
        if createdon is not APIHelper.SKIP:
            self.createdon = createdon 
        if delegateid is not APIHelper.SKIP:
            self.delegateid = delegateid 
        if description is not APIHelper.SKIP:
            self.description = description 
        if disabled is not APIHelper.SKIP:
            self.disabled = disabled 
        if email is not APIHelper.SKIP:
            self.email = email 
        if filter is not APIHelper.SKIP:
            self.filter = filter 
        if id is not APIHelper.SKIP:
            self.id = id 
        if kind is not APIHelper.SKIP:
            self.kind = kind 
        if laststreamingstatus is not APIHelper.SKIP:
            self.laststreamingstatus = laststreamingstatus 
        if laststreamingtime is not APIHelper.SKIP:
            self.laststreamingtime = laststreamingtime 
        if lastupdated is not APIHelper.SKIP:
            self.lastupdated = lastupdated 
        if name is not APIHelper.SKIP:
            self.name = name 
        if networkfailures is not APIHelper.SKIP:
            self.networkfailures = networkfailures 
        if streamfailures is not APIHelper.SKIP:
            self.streamfailures = streamfailures 
        if streamkind is not APIHelper.SKIP:
            self.streamkind = streamkind 
        if targetid is not APIHelper.SKIP:
            self.targetid = targetid 
        if targettype is not APIHelper.SKIP:
            self.targettype = targettype 
        if version is not APIHelper.SKIP:
            self.version = version 
        if versionid is not APIHelper.SKIP:
            self.versionid = versionid 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        configurationfailures = dictionary.get("configurationfailures") if dictionary.get("configurationfailures") else APIHelper.SKIP
        createdon = dictionary.get("createdon") if dictionary.get("createdon") else APIHelper.SKIP
        delegateid = dictionary.get("delegateid") if dictionary.get("delegateid") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        disabled = dictionary.get("disabled") if "disabled" in dictionary.keys() else APIHelper.SKIP
        email = dictionary.get("email") if dictionary.get("email") else APIHelper.SKIP
        filter = dictionary.get("filter") if dictionary.get("filter") else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        kind = dictionary.get("kind") if dictionary.get("kind") else APIHelper.SKIP
        laststreamingstatus = dictionary.get("laststreamingstatus") if dictionary.get("laststreamingstatus") else APIHelper.SKIP
        laststreamingtime = dictionary.get("laststreamingtime") if dictionary.get("laststreamingtime") else APIHelper.SKIP
        lastupdated = dictionary.get("lastupdated") if dictionary.get("lastupdated") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        networkfailures = dictionary.get("networkfailures") if dictionary.get("networkfailures") else APIHelper.SKIP
        streamfailures = dictionary.get("streamfailures") if dictionary.get("streamfailures") else APIHelper.SKIP
        streamkind = dictionary.get("streamkind") if dictionary.get("streamkind") else APIHelper.SKIP
        targetid = dictionary.get("targetid") if dictionary.get("targetid") else APIHelper.SKIP
        targettype = dictionary.get("targettype") if dictionary.get("targettype") else APIHelper.SKIP
        version = dictionary.get("version") if dictionary.get("version") else APIHelper.SKIP
        versionid = dictionary.get("versionid") if dictionary.get("versionid") else APIHelper.SKIP
        # Return an object of this model
        return cls(configurationfailures,
                   createdon,
                   delegateid,
                   description,
                   disabled,
                   email,
                   filter,
                   id,
                   kind,
                   laststreamingstatus,
                   laststreamingtime,
                   lastupdated,
                   name,
                   networkfailures,
                   streamfailures,
                   streamkind,
                   targetid,
                   targettype,
                   version,
                   versionid)
