# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.target_authentication_body_headers import TargetAuthenticationBodyHeaders
from verizon.models.target_authentication_body_host import TargetAuthenticationBodyHost


class TargetAuthenticationBody(object):

    """Implementation of the 'TargetAuthenticationBody' model.

    TODO: type model description here.

    Attributes:
        grant_type (str): Authentication grant type.
        refresh_token (str): Refresh token.
        scope (str): Authentication scopes.
        headers (TargetAuthenticationBodyHeaders): Authentication headers.
        host (TargetAuthenticationBodyHost): Host information.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "grant_type": 'grant_type',
        "refresh_token": 'refresh_token',
        "scope": 'scope',
        "headers": 'headers',
        "host": 'host'
    }

    _optionals = [
        'grant_type',
        'refresh_token',
        'scope',
        'headers',
        'host',
    ]

    def __init__(self,
                 grant_type=APIHelper.SKIP,
                 refresh_token=APIHelper.SKIP,
                 scope=APIHelper.SKIP,
                 headers=APIHelper.SKIP,
                 host=APIHelper.SKIP):
        """Constructor for the TargetAuthenticationBody class"""

        # Initialize members of the class
        if grant_type is not APIHelper.SKIP:
            self.grant_type = grant_type 
        if refresh_token is not APIHelper.SKIP:
            self.refresh_token = refresh_token 
        if scope is not APIHelper.SKIP:
            self.scope = scope 
        if headers is not APIHelper.SKIP:
            self.headers = headers 
        if host is not APIHelper.SKIP:
            self.host = host 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        grant_type = dictionary.get("grant_type") if dictionary.get("grant_type") else APIHelper.SKIP
        refresh_token = dictionary.get("refresh_token") if dictionary.get("refresh_token") else APIHelper.SKIP
        scope = dictionary.get("scope") if dictionary.get("scope") else APIHelper.SKIP
        headers = TargetAuthenticationBodyHeaders.from_dictionary(dictionary.get('headers')) if 'headers' in dictionary.keys() else APIHelper.SKIP
        host = TargetAuthenticationBodyHost.from_dictionary(dictionary.get('host')) if 'host' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(grant_type,
                   refresh_token,
                   scope,
                   headers,
                   host)
