# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.trigger_notification import TriggerNotification
from verizon.models.usage_anomaly_attributes import UsageAnomalyAttributes


class TriggerType2(object):

    """Implementation of the 'TriggerType2' model.

    Trigger details.

    Attributes:
        anomalyattributes (UsageAnomalyAttributes): The details of the
            UsageAnomaly trigger.
        notification (TriggerNotification): The notification details of the
            trigger.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "anomalyattributes": 'anomalyattributes',
        "notification": 'notification'
    }

    _optionals = [
        'anomalyattributes',
        'notification',
    ]

    def __init__(self,
                 anomalyattributes=APIHelper.SKIP,
                 notification=APIHelper.SKIP):
        """Constructor for the TriggerType2 class"""

        # Initialize members of the class
        if anomalyattributes is not APIHelper.SKIP:
            self.anomalyattributes = anomalyattributes 
        if notification is not APIHelper.SKIP:
            self.notification = notification 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        anomalyattributes = UsageAnomalyAttributes.from_dictionary(dictionary.get('anomalyattributes')) if 'anomalyattributes' in dictionary.keys() else APIHelper.SKIP
        notification = TriggerNotification.from_dictionary(dictionary.get('notification')) if 'notification' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(anomalyattributes,
                   notification)
