# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.promo_alert import PromoAlert


class Triggervalues2(object):

    """Implementation of the 'Triggervalues2' model.

    TODO: type model description here.

    Attributes:
        trigger_id (str): TODO: type description here.
        trigger_name (str): TODO: type description here.
        account_name (str): TODO: type description here.
        organization_name (str): TODO: type description here.
        trigger_category (str): TODO: type description here.
        promo_alerts (List[PromoAlert]): TODO: type description here.
        active (bool): TODO: type description here.
        created_at (datetime): TODO: type description here.
        modified_at (datetime): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "trigger_id": 'triggerId',
        "trigger_name": 'triggerName',
        "account_name": 'accountName',
        "organization_name": 'organizationName',
        "trigger_category": 'triggerCategory',
        "promo_alerts": 'promoAlerts',
        "active": 'active',
        "created_at": 'createdAt',
        "modified_at": 'modifiedAt'
    }

    _optionals = [
        'trigger_id',
        'trigger_name',
        'account_name',
        'organization_name',
        'trigger_category',
        'promo_alerts',
        'active',
        'created_at',
        'modified_at',
    ]

    def __init__(self,
                 trigger_id=APIHelper.SKIP,
                 trigger_name=APIHelper.SKIP,
                 account_name=APIHelper.SKIP,
                 organization_name=APIHelper.SKIP,
                 trigger_category=APIHelper.SKIP,
                 promo_alerts=APIHelper.SKIP,
                 active=APIHelper.SKIP,
                 created_at=APIHelper.SKIP,
                 modified_at=APIHelper.SKIP):
        """Constructor for the Triggervalues2 class"""

        # Initialize members of the class
        if trigger_id is not APIHelper.SKIP:
            self.trigger_id = trigger_id 
        if trigger_name is not APIHelper.SKIP:
            self.trigger_name = trigger_name 
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if organization_name is not APIHelper.SKIP:
            self.organization_name = organization_name 
        if trigger_category is not APIHelper.SKIP:
            self.trigger_category = trigger_category 
        if promo_alerts is not APIHelper.SKIP:
            self.promo_alerts = promo_alerts 
        if active is not APIHelper.SKIP:
            self.active = active 
        if created_at is not APIHelper.SKIP:
            self.created_at = APIHelper.apply_datetime_converter(created_at, APIHelper.RFC3339DateTime) if created_at else None 
        if modified_at is not APIHelper.SKIP:
            self.modified_at = APIHelper.apply_datetime_converter(modified_at, APIHelper.RFC3339DateTime) if modified_at else None 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        trigger_id = dictionary.get("triggerId") if dictionary.get("triggerId") else APIHelper.SKIP
        trigger_name = dictionary.get("triggerName") if dictionary.get("triggerName") else APIHelper.SKIP
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        organization_name = dictionary.get("organizationName") if dictionary.get("organizationName") else APIHelper.SKIP
        trigger_category = dictionary.get("triggerCategory") if dictionary.get("triggerCategory") else APIHelper.SKIP
        promo_alerts = None
        if dictionary.get('promoAlerts') is not None:
            promo_alerts = [PromoAlert.from_dictionary(x) for x in dictionary.get('promoAlerts')]
        else:
            promo_alerts = APIHelper.SKIP
        active = dictionary.get("active") if "active" in dictionary.keys() else APIHelper.SKIP
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdAt")).datetime if dictionary.get("createdAt") else APIHelper.SKIP
        modified_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("modifiedAt")).datetime if dictionary.get("modifiedAt") else APIHelper.SKIP
        # Return an object of this model
        return cls(trigger_id,
                   trigger_name,
                   account_name,
                   organization_name,
                   trigger_category,
                   promo_alerts,
                   active,
                   created_at,
                   modified_at)
