# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""


class UsageTriggerResponse(object):

    """Implementation of the 'UsageTriggerResponse' model.

    TODO: type model description here.

    Attributes:
        trigger_id (str): Unique usage triggerId
        trigger_name (str): Usage trigger name
        account_name (str): Account name
        service_name (ServiceNameEnum): Service name
        threshold_value (str): Percent of subscription at which trigger will
            send an alert
        allow_excess (bool): allowExcess determines whether to restrict usage
            after exceeds limits
        send_sms_notification (bool): Send SMS (text) alerts when the
            thresholdValue is reached.
        sms_phone_numbers (str): comma seperated value of list of Phone
            numbers for SMS notifications
        send_email_notification (bool): Send email alerts when the
            thresholdValue is reached.
        email_addresses (str): comma seperated value of list of Email
            addresses for Email notifications
        create_date (str): UTC Date when the usage trigger was created
        update_date (str): UTC Date when the usage trigger was last updated

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "trigger_id": 'triggerId',
        "trigger_name": 'triggerName',
        "account_name": 'accountName',
        "service_name": 'serviceName',
        "threshold_value": 'thresholdValue',
        "allow_excess": 'allowExcess',
        "send_sms_notification": 'sendSmsNotification',
        "sms_phone_numbers": 'smsPhoneNumbers',
        "send_email_notification": 'sendEmailNotification',
        "email_addresses": 'emailAddresses',
        "create_date": 'createDate',
        "update_date": 'updateDate'
    }

    def __init__(self,
                 trigger_id=None,
                 trigger_name=None,
                 account_name=None,
                 service_name='Location',
                 threshold_value=None,
                 allow_excess=None,
                 send_sms_notification=None,
                 sms_phone_numbers=None,
                 send_email_notification=None,
                 email_addresses=None,
                 create_date=None,
                 update_date=None):
        """Constructor for the UsageTriggerResponse class"""

        # Initialize members of the class
        self.trigger_id = trigger_id 
        self.trigger_name = trigger_name 
        self.account_name = account_name 
        self.service_name = service_name 
        self.threshold_value = threshold_value 
        self.allow_excess = allow_excess 
        self.send_sms_notification = send_sms_notification 
        self.sms_phone_numbers = sms_phone_numbers 
        self.send_email_notification = send_email_notification 
        self.email_addresses = email_addresses 
        self.create_date = create_date 
        self.update_date = update_date 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        trigger_id = dictionary.get("triggerId") if dictionary.get("triggerId") else None
        trigger_name = dictionary.get("triggerName") if dictionary.get("triggerName") else None
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        service_name = dictionary.get("serviceName") if dictionary.get("serviceName") else 'Location'
        threshold_value = dictionary.get("thresholdValue") if dictionary.get("thresholdValue") else None
        allow_excess = dictionary.get("allowExcess") if "allowExcess" in dictionary.keys() else None
        send_sms_notification = dictionary.get("sendSmsNotification") if "sendSmsNotification" in dictionary.keys() else None
        sms_phone_numbers = dictionary.get("smsPhoneNumbers") if dictionary.get("smsPhoneNumbers") else None
        send_email_notification = dictionary.get("sendEmailNotification") if "sendEmailNotification" in dictionary.keys() else None
        email_addresses = dictionary.get("emailAddresses") if dictionary.get("emailAddresses") else None
        create_date = dictionary.get("createDate") if dictionary.get("createDate") else None
        update_date = dictionary.get("updateDate") if dictionary.get("updateDate") else None
        # Return an object of this model
        return cls(trigger_id,
                   trigger_name,
                   account_name,
                   service_name,
                   threshold_value,
                   allow_excess,
                   send_sms_notification,
                   sms_phone_numbers,
                   send_email_notification,
                   email_addresses,
                   create_date,
                   update_date)
